/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.execution.streams.StreamFlatMapBuilder;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.structured.SchemaKStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FlatMapNode
extends SingleSourcePlanNode {
    private final ImmutableList<FunctionCall> tableFunctions;
    private final ImmutableMap<Integer, Expression> columnMappings;
    private final LogicalSchema schema;

    public FlatMapNode(PlanNodeId id, PlanNode source, FunctionRegistry functionRegistry, ImmutableAnalysis analysis) {
        super(id, source.getNodeOutputType(), Optional.empty(), source);
        this.schema = FlatMapNode.buildSchema(source, functionRegistry, analysis);
        this.tableFunctions = ImmutableList.copyOf(analysis.getTableFunctions());
        this.columnMappings = FlatMapNode.buildColumnMappings(functionRegistry, analysis);
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    public Expression resolveSelect(int idx, Expression expression) {
        Expression resolved = (Expression)this.columnMappings.get((Object)idx);
        return resolved == null ? expression : resolved;
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        QueryContext.Stacker contextStacker = buildContext.buildNodeContext(this.getId().toString());
        return this.getSource().buildStream(buildContext).flatMap((List<FunctionCall>)this.tableFunctions, contextStacker);
    }

    private static ImmutableMap<Integer, Expression> buildColumnMappings(FunctionRegistry functionRegistry, ImmutableAnalysis analysis) {
        TableFunctionExpressionRewriter tableFunctionExpressionRewriter = new TableFunctionExpressionRewriter(functionRegistry);
        ImmutableMap.Builder buildContext = ImmutableMap.builder();
        List<SelectItem> selectItems = analysis.getSelectItems();
        for (int idx = 0; idx < selectItems.size(); ++idx) {
            SelectItem selectItem = selectItems.get(idx);
            if (!(selectItem instanceof SingleColumn)) continue;
            SingleColumn singleColumn = (SingleColumn)selectItem;
            Expression rewritten = ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((TableFunctionExpressionRewriter)tableFunctionExpressionRewriter).process(arg_0, arg_1), singleColumn.getExpression());
            if (rewritten.equals((Object)singleColumn.getExpression())) continue;
            buildContext.put((Object)idx, (Object)rewritten);
        }
        return buildContext.build();
    }

    private static LogicalSchema buildSchema(PlanNode source, FunctionRegistry functionRegistry, ImmutableAnalysis analysis) {
        return StreamFlatMapBuilder.buildSchema((LogicalSchema)source.getSchema(), analysis.getTableFunctions(), (FunctionRegistry)functionRegistry);
    }

    private static class TableFunctionExpressionRewriter
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private final FunctionRegistry functionRegistry;
        private int variableIndex = 0;

        TableFunctionExpressionRewriter(FunctionRegistry functionRegistry) {
            super(Optional.empty());
            this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        }

        public Optional<Expression> visitFunctionCall(FunctionCall node, ExpressionTreeRewriter.Context<Void> context) {
            FunctionName functionName = node.getName();
            if (this.functionRegistry.isTableFunction(functionName)) {
                ColumnName varName = ColumnNames.synthesisedSchemaColumn((int)this.variableIndex);
                ++this.variableIndex;
                return Optional.of(new UnqualifiedColumnReferenceExp(node.getLocation(), varName));
            }
            ArrayList<Expression> arguments = new ArrayList<Expression>();
            for (Expression argExpression : node.getArguments()) {
                arguments.add(context.process(argExpression));
            }
            return Optional.of(new FunctionCall(node.getLocation(), node.getName(), arguments));
        }
    }
}

