/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;

public final class ImplicitlyCastResolver {
    private ImplicitlyCastResolver() {
    }

    public static Expression resolve(Expression expression, SqlType sqlType) {
        if (sqlType instanceof SqlDecimal) {
            return ImplicitlyCastResolver.resolveToDecimal(expression, (SqlDecimal)sqlType);
        }
        return expression;
    }

    private static Expression resolveToDecimal(Expression expression, SqlDecimal toDecimalType) {
        BigDecimal literalValue;
        if (expression instanceof IntegerLiteral) {
            literalValue = BigDecimal.valueOf(((IntegerLiteral)expression).getValue().intValue());
        } else if (expression instanceof LongLiteral) {
            literalValue = BigDecimal.valueOf(((LongLiteral)expression).getValue());
        } else if (expression instanceof DoubleLiteral) {
            literalValue = BigDecimal.valueOf(((DoubleLiteral)expression).getValue());
        } else if (expression instanceof DecimalLiteral) {
            literalValue = ((DecimalLiteral)expression).getValue();
        } else {
            return expression;
        }
        SqlDecimal fromDecimalType = (SqlDecimal)DecimalUtil.fromValue((BigDecimal)literalValue);
        if (DecimalUtil.canImplicitlyCast((SqlDecimal)fromDecimalType, (SqlDecimal)toDecimalType)) {
            return new DecimalLiteral(expression.getLocation(), DecimalUtil.cast((BigDecimal)literalValue, (int)toDecimalType.getPrecision(), (int)toDecimalType.getScale()));
        }
        return expression;
    }
}

