/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.planner.plan.LookupConstraint;
import io.confluent.ksql.planner.plan.QueryFilterNode;
import java.util.Objects;
import java.util.Optional;

public class KeyConstraint
implements LookupConstraint,
Locator.KsqlKey {
    private final ConstraintOperator operator;
    private final GenericKey key;
    private final Optional<QueryFilterNode.WindowBounds> windowBounds;

    public KeyConstraint(ConstraintOperator operator, GenericKey key, Optional<QueryFilterNode.WindowBounds> windowBounds) {
        this.operator = operator;
        this.key = key;
        this.windowBounds = windowBounds;
    }

    public GenericKey getKey() {
        return this.key;
    }

    public ConstraintOperator getOperator() {
        return this.operator;
    }

    public Optional<QueryFilterNode.WindowBounds> getWindowBounds() {
        return this.windowBounds;
    }

    public Locator.KsqlKey getKsqlKey() {
        return this;
    }

    public boolean isRangeOperator() {
        return this.operator != ConstraintOperator.EQUAL;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.windowBounds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyConstraint that = (KeyConstraint)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.windowBounds, that.windowBounds);
    }

    public String toString() {
        return this.key.toString() + "-" + this.windowBounds.toString();
    }

    public static enum ConstraintOperator {
        EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL;

    }
}

