/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.VerifiableNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.structured.SchemaKStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KsqlStructuredDataOutputNode
extends OutputNode {
    private final KsqlTopic ksqlTopic;
    private final boolean doCreateInto;
    private final SourceName sinkName;
    private final boolean orReplace;

    public KsqlStructuredDataOutputNode(PlanNodeId id, PlanNode source, LogicalSchema schema, Optional<TimestampColumn> timestampColumn, KsqlTopic ksqlTopic, OptionalInt limit, boolean doCreateInto, SourceName sinkName, boolean orReplace) {
        super(id, source, schema, limit, timestampColumn);
        this.ksqlTopic = Objects.requireNonNull(ksqlTopic, "ksqlTopic");
        this.doCreateInto = doCreateInto;
        this.sinkName = Objects.requireNonNull(sinkName, "sinkName");
        this.orReplace = orReplace;
        KsqlStructuredDataOutputNode.validate(source, sinkName);
    }

    public boolean createInto() {
        return this.doCreateInto;
    }

    public KsqlTopic getKsqlTopic() {
        return this.ksqlTopic;
    }

    public boolean getOrReplace() {
        return this.orReplace;
    }

    @Override
    public Optional<SourceName> getSinkName() {
        return Optional.of(this.sinkName);
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        PlanNode source = this.getSource();
        SchemaKStream<?> schemaKStream = source.buildStream(buildContext);
        QueryContext.Stacker contextStacker = buildContext.buildNodeContext(this.getId().toString());
        return schemaKStream.into(this.ksqlTopic, contextStacker, this.getTimestampColumn());
    }

    private static void validate(PlanNode source, SourceName sinkName) {
        if (!(source instanceof VerifiableNode)) {
            throw new IllegalArgumentException("VerifiableNode required");
        }
        ((VerifiableNode)((Object)source)).validateKeyPresent(sinkName);
        LogicalSchema schema = source.getSchema();
        String duplicates = schema.columns().stream().map(Column::name).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).map(Name::toString).collect(Collectors.joining(", "));
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Value columns clash with key columns: " + duplicates);
        }
    }
}

