/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import java.util.Optional;

public final class PlanBuildContext {
    private final KsqlConfig ksqlConfig;
    private final ServiceContext serviceContext;
    private final FunctionRegistry functionRegistry;
    private final Optional<PlanInfo> planInfo;

    public static PlanBuildContext of(KsqlConfig ksqlConfig, ServiceContext serviceContext, FunctionRegistry functionRegistry, Optional<PlanInfo> planInfo) {
        return new PlanBuildContext(ksqlConfig, serviceContext, functionRegistry, planInfo);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    private PlanBuildContext(KsqlConfig ksqlConfig, ServiceContext serviceContext, FunctionRegistry functionRegistry, Optional<PlanInfo> planInfo) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.planInfo = Objects.requireNonNull(planInfo, "planInfo");
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KsqlConfig getKsqlConfig() {
        return this.ksqlConfig;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public Optional<PlanInfo> getPlanInfo() {
        return this.planInfo;
    }

    public PlanBuildContext withKsqlConfig(KsqlConfig newConfig) {
        return PlanBuildContext.of(newConfig, this.serviceContext, this.functionRegistry, this.planInfo);
    }

    public QueryContext.Stacker buildNodeContext(String context) {
        return new QueryContext.Stacker().push(new String[]{context});
    }
}

