/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.Lists;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.engine.rewrite.StatementRewriteForMagicPseudoTimestamp;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.planner.plan.LogicRewriter;
import java.util.List;
import java.util.Optional;

public final class PullQueryRewriter {
    private PullQueryRewriter() {
    }

    public static Expression rewrite(Expression expression) {
        Expression pseudoTimestamp = new StatementRewriteForMagicPseudoTimestamp().rewrite(expression);
        Expression betweenPredicatesRemoved = PullQueryRewriter.rewriteBetweenPredicates(pseudoTimestamp);
        Expression inPredicatesRemoved = PullQueryRewriter.rewriteInPredicates(betweenPredicatesRemoved);
        return LogicRewriter.rewriteDNF(inPredicatesRemoved);
    }

    public static Expression rewriteBetweenPredicates(Expression expression) {
        return new ExpressionTreeRewriter<Object>((arg_0, arg_1) -> ((BetweenPredicateRewriter)new BetweenPredicateRewriter()).process(arg_0, arg_1)).rewrite(expression, null);
    }

    public static Expression rewriteInPredicates(Expression expression) {
        return new ExpressionTreeRewriter<Object>((arg_0, arg_1) -> ((InPredicateRewriter)new InPredicateRewriter()).process(arg_0, arg_1)).rewrite(expression, null);
    }

    private static final class BetweenPredicateRewriter
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private BetweenPredicateRewriter() {
        }

        public Optional<Expression> visitExpression(Expression node, ExpressionTreeRewriter.Context<Void> context) {
            return Optional.empty();
        }

        public Optional<Expression> visitBetweenPredicate(BetweenPredicate node, ExpressionTreeRewriter.Context<Void> context) {
            ComparisonExpression leftComparisonExpression = new ComparisonExpression(node.getLocation(), ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin());
            ComparisonExpression rightComparisonExpression = new ComparisonExpression(node.getLocation(), ComparisonExpression.Type.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax());
            LogicalBinaryExpression currentExpression = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, (Expression)leftComparisonExpression, (Expression)rightComparisonExpression);
            return Optional.of(currentExpression);
        }
    }

    private static final class InPredicateRewriter
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private InPredicateRewriter() {
        }

        public Optional<Expression> visitExpression(Expression node, ExpressionTreeRewriter.Context<Void> context) {
            return Optional.empty();
        }

        public Optional<Expression> visitInPredicate(InPredicate node, ExpressionTreeRewriter.Context<Void> context) {
            ComparisonExpression currentExpression = null;
            for (Expression inValueListExp : Lists.reverse((List)node.getValueList().getValues())) {
                ComparisonExpression comparisonExpression = new ComparisonExpression(node.getLocation(), ComparisonExpression.Type.EQUAL, node.getValue(), inValueListExp);
                if (currentExpression == null) {
                    currentExpression = comparisonExpression;
                    continue;
                }
                currentExpression = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, (Expression)comparisonExpression, (Expression)currentExpression);
            }
            if (currentExpression != null) {
                return Optional.of(currentExpression);
            }
            throw new IllegalStateException("Shouldn't have an empty in predicate");
        }
    }
}

