/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.analyzer.PullQueryValidator;
import io.confluent.ksql.engine.generic.GenericExpressionResolver;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.TraversalExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.interpreter.InterpretedExpressionFactory;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.KeyConstraint;
import io.confluent.ksql.planner.plan.LogicRewriter;
import io.confluent.ksql.planner.plan.LookupConstraint;
import io.confluent.ksql.planner.plan.NonKeyConstraint;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.PullQueryRewriter;
import io.confluent.ksql.planner.plan.QueryLogicalPlanUtil;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.DefaultSqlValueCoercer;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.timestamp.PartialStringToTimestampParser;
import java.time.Instant;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryFilterNode
extends SingleSourcePlanNode {
    private static final Logger LOG = LogManager.getLogger(QueryFilterNode.class);
    private static final Set<ComparisonExpression.Type> VALID_WINDOW_BOUND_COMPARISONS = ImmutableSet.of((Object)ComparisonExpression.Type.EQUAL, (Object)ComparisonExpression.Type.GREATER_THAN, (Object)ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Object)ComparisonExpression.Type.LESS_THAN, (Object)ComparisonExpression.Type.LESS_THAN_OR_EQUAL);
    private final boolean isWindowed;
    private final ExpressionEvaluator compiledWhereClause;
    private final boolean addAdditionalColumnsToIntermediateSchema;
    private final LogicalSchema intermediateSchema;
    private final MetaStore metaStore;
    private final KsqlConfig ksqlConfig;
    private final LogicalSchema schema = this.getSource().getSchema();
    private final Expression rewrittenPredicate;
    private final List<Expression> disjuncts;
    private final ImmutableList<LookupConstraint> lookupConstraints;
    private final Set<UnqualifiedColumnReferenceExp> keyColumns = new HashSet<UnqualifiedColumnReferenceExp>();
    private final Set<UnqualifiedColumnReferenceExp> systemColumns = new HashSet<UnqualifiedColumnReferenceExp>();
    private final QueryPlannerOptions queryPlannerOptions;
    private final boolean requiresTableScan;

    public QueryFilterNode(PlanNodeId id, PlanNode source, Expression predicate, MetaStore metaStore, KsqlConfig ksqlConfig, boolean isWindowed, QueryPlannerOptions queryPlannerOptions) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
        Objects.requireNonNull(predicate, "predicate");
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.queryPlannerOptions = queryPlannerOptions;
        this.rewrittenPredicate = PullQueryRewriter.rewrite(predicate);
        this.disjuncts = LogicRewriter.extractDisjuncts(this.rewrittenPredicate);
        this.isWindowed = isWindowed;
        this.requiresTableScan = this.validateWhereClauseAndCheckTableScan();
        this.extractKeysAndSystemCols();
        this.lookupConstraints = this.extractLookupConstraints();
        this.addAdditionalColumnsToIntermediateSchema = this.shouldAddAdditionalColumnsInSchema();
        this.intermediateSchema = QueryLogicalPlanUtil.buildIntermediateSchema(source.getSchema().withoutPseudoAndKeyColsInValue(), this.addAdditionalColumnsToIntermediateSchema, isWindowed);
        this.compiledWhereClause = QueryFilterNode.getExpressionEvaluator(this.rewrittenPredicate, this.intermediateSchema, metaStore, ksqlConfig, queryPlannerOptions);
    }

    public Expression getRewrittenPredicate() {
        return this.rewrittenPredicate;
    }

    @Override
    public LogicalSchema getSchema() {
        return this.getSource().getSchema();
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildCtx) {
        throw new UnsupportedOperationException();
    }

    public ExpressionEvaluator getCompiledWhereClause() {
        return this.compiledWhereClause;
    }

    public boolean isWindowed() {
        return this.isWindowed;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="lookupConstraints is ImmutableList")
    public List<LookupConstraint> getLookupConstraints() {
        return this.lookupConstraints;
    }

    public boolean getAddAdditionalColumnsToIntermediateSchema() {
        return this.addAdditionalColumnsToIntermediateSchema;
    }

    public LogicalSchema getIntermediateSchema() {
        return this.intermediateSchema;
    }

    private boolean validateWhereClauseAndCheckTableScan() {
        for (Expression disjunct : this.disjuncts) {
            Validator validator = new Validator();
            validator.process(disjunct, null);
            if (validator.requiresTableScan) {
                return true;
            }
            if (!validator.isKeyedQuery) {
                if (this.queryPlannerOptions.getTableScansEnabled()) {
                    return true;
                }
                throw QueryFilterNode.invalidWhereClauseException("WHERE clause missing key column for disjunct: " + disjunct.toString(), this.isWindowed);
            }
            if (validator.seenKeys.isEmpty() || validator.seenKeys.cardinality() == this.schema.key().size()) continue;
            if (this.queryPlannerOptions.getTableScansEnabled()) {
                return true;
            }
            List seenKeyNames = validator.seenKeys.stream().boxed().map(i -> (Column)this.schema.key().get((int)i)).map(Column::name).collect(Collectors.toList());
            throw QueryFilterNode.invalidWhereClauseException("Multi-column sources must specify every key in the WHERE clause. Specified: " + String.valueOf(seenKeyNames) + " Expected: " + String.valueOf(this.schema.key()), this.isWindowed);
        }
        return false;
    }

    private void extractKeysAndSystemCols() {
        new KeyAndSystemColsExtractor().process(this.rewrittenPredicate, null);
    }

    private ImmutableList<LookupConstraint> extractLookupConstraints() {
        if (this.requiresTableScan) {
            LOG.debug("Skipping extracting key value extraction. Already requires table scan");
            return ImmutableList.of((Object)new NonKeyConstraint());
        }
        ImmutableList.Builder constraintPerDisjunct = ImmutableList.builder();
        for (Expression disjunct : this.disjuncts) {
            Optional<WindowBounds> optionalWindowBounds;
            KeyValueExtractor keyValueExtractor = new KeyValueExtractor();
            keyValueExtractor.process(disjunct, null);
            if (this.isWindowed) {
                WindowBounds windowBounds = new WindowBounds();
                new WindowBoundsExtractor().process(disjunct, windowBounds);
                optionalWindowBounds = Optional.of(windowBounds);
            } else {
                optionalWindowBounds = Optional.empty();
            }
            LookupConstraint constraint = keyValueExtractor.getLookupConstraint(optionalWindowBounds);
            constraintPerDisjunct.add((Object)constraint);
        }
        return constraintPerDisjunct.build();
    }

    private UnqualifiedColumnReferenceExp getColumnRefSideOrNull(ComparisonExpression comp) {
        return (UnqualifiedColumnReferenceExp)(comp.getRight() instanceof UnqualifiedColumnReferenceExp ? comp.getRight() : (comp.getLeft() instanceof UnqualifiedColumnReferenceExp ? comp.getLeft() : null));
    }

    private Expression getNonColumnRefSide(ComparisonExpression comparison) {
        return comparison.getRight() instanceof UnqualifiedColumnReferenceExp ? comparison.getLeft() : comparison.getRight();
    }

    public static KsqlException invalidWhereClauseException(String msg, boolean windowed) {
        String additional = !windowed ? "" : System.lineSeparator() + " - (optionally) limits the time bounds of the windowed table." + System.lineSeparator() + "\t Bounds on " + String.valueOf(SystemColumns.windowBoundsColumnNames()) + " are supported" + System.lineSeparator() + "\t Supported operators are " + String.valueOf(VALID_WINDOW_BOUND_COMPARISONS);
        return new KsqlException(msg + ". " + PullQueryValidator.PULL_QUERY_SYNTAX_HELP + System.lineSeparator() + "Pull queries require a WHERE clause that:" + System.lineSeparator() + " - includes a key equality expression, e.g. `SELECT * FROM X WHERE <key-column> = Y;`." + System.lineSeparator() + " - in the case of a multi-column key, is a conjunction of equality expressions that cover all key columns." + System.lineSeparator() + " - to support range expressions, e.g.,  SELECT * FROM X WHERE <key-column> < Y;`, range scans need to be enabled by setting ksql.query.pull.range.scan.enabled=true" + additional + System.lineSeparator() + "If more flexible queries are needed, , table scans can be enabled by setting ksql.query.pull.table.scan.enabled=true.");
    }

    private boolean shouldAddAdditionalColumnsInSchema() {
        boolean hasSystemColumns = !this.systemColumns.isEmpty();
        boolean hasKeyColumns = !this.keyColumns.isEmpty();
        return hasSystemColumns || hasKeyColumns;
    }

    private static ExpressionEvaluator getExpressionEvaluator(Expression expression, LogicalSchema schema, MetaStore metaStore, KsqlConfig ksqlConfig, QueryPlannerOptions queryPlannerOptions) {
        if (queryPlannerOptions.getInterpreterEnabled()) {
            return InterpretedExpressionFactory.create((Expression)expression, (LogicalSchema)schema, (FunctionRegistry)metaStore, (KsqlConfig)ksqlConfig);
        }
        return CodeGenRunner.compileExpression((Expression)expression, (String)"Predicate", (LogicalSchema)schema, (KsqlConfig)ksqlConfig, (FunctionRegistry)metaStore);
    }

    private final class Validator
    extends TraversalExpressionVisitor<Object> {
        private final BitSet seenKeys;
        private boolean isKeyedQuery = false;
        private boolean requiresTableScan;

        Validator() {
            this.seenKeys = new BitSet(QueryFilterNode.this.schema.key().size());
            this.requiresTableScan = false;
        }

        public Void process(Expression node, Object context) {
            if (!(node instanceof LogicalBinaryExpression || node instanceof ComparisonExpression || node instanceof LikePredicate)) {
                throw QueryFilterNode.invalidWhereClauseException("Unsupported expression in WHERE clause: " + String.valueOf(node), false);
            }
            super.process(node, context);
            return null;
        }

        public Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            if (node.getType() != LogicalBinaryExpression.Type.AND) {
                this.setTableScanOrElseThrow(() -> QueryFilterNode.invalidWhereClauseException("Only AND expressions are supported: " + String.valueOf(node), false));
            }
            this.process(node.getLeft(), context);
            this.process(node.getRight(), context);
            return null;
        }

        public Void visitComparisonExpression(ComparisonExpression node, Object context) {
            UnqualifiedColumnReferenceExp column = QueryFilterNode.this.getColumnRefSideOrNull(node);
            if (column != null) {
                Expression other = QueryFilterNode.this.getNonColumnRefSide(node);
                HasColumnRef hasColumnRef = new HasColumnRef();
                hasColumnRef.process(other, null);
                if (hasColumnRef.hasColumnRef()) {
                    this.setTableScanOrElseThrow(() -> QueryFilterNode.invalidWhereClauseException("A comparison must be between a key column and a resolvable expression", QueryFilterNode.this.isWindowed));
                    return null;
                }
            } else {
                this.setTableScanOrElseThrow(() -> QueryFilterNode.invalidWhereClauseException("A comparison must directly reference a key column", QueryFilterNode.this.isWindowed));
                return null;
            }
            return this.visitColumnComparisonExpression(column, node);
        }

        private Void visitColumnComparisonExpression(UnqualifiedColumnReferenceExp column, ComparisonExpression node) {
            ColumnName columnName = column.getColumnName();
            if (columnName.equals((Object)SystemColumns.WINDOWSTART_NAME) || columnName.equals((Object)SystemColumns.WINDOWEND_NAME)) {
                ComparisonExpression.Type type = node.getType();
                if (!VALID_WINDOW_BOUND_COMPARISONS.contains(type)) {
                    throw QueryFilterNode.invalidWhereClauseException("Unsupported " + String.valueOf(columnName) + " bounds: " + String.valueOf(type), true);
                }
                if (!QueryFilterNode.this.isWindowed) {
                    throw QueryFilterNode.invalidWhereClauseException("Cannot use WINDOWSTART/WINDOWEND on non-windowed source", false);
                }
                return null;
            }
            Column col = (Column)QueryFilterNode.this.schema.findColumn(columnName).orElseThrow(() -> QueryFilterNode.invalidWhereClauseException("Bound on non-existent column " + String.valueOf(columnName), QueryFilterNode.this.isWindowed));
            if (col.namespace() == Column.Namespace.KEY) {
                if (!this.isKeyQuery(node)) {
                    this.setTableScanOrElseThrow(() -> QueryFilterNode.invalidWhereClauseException("Bound on key columns '" + String.valueOf(QueryFilterNode.this.getSource().getSchema().key()) + "' must currently be '='", QueryFilterNode.this.isWindowed));
                }
                if (this.seenKeys.get(col.index()) && !QueryFilterNode.this.queryPlannerOptions.getTableScansEnabled()) {
                    throw QueryFilterNode.invalidWhereClauseException("A comparison condition on the key column cannot be combined with other comparisons such as an IN predicate", QueryFilterNode.this.isWindowed);
                }
                this.seenKeys.set(col.index());
                this.isKeyedQuery = true;
                return null;
            }
            return null;
        }

        public Void visitLikePredicate(LikePredicate node, Object context) {
            if (node.getValue() instanceof UnqualifiedColumnReferenceExp) {
                UnqualifiedColumnReferenceExp column = (UnqualifiedColumnReferenceExp)node.getValue();
                ColumnName columnName = column.getColumnName();
                Column col = (Column)QueryFilterNode.this.schema.findColumn(columnName).orElseThrow(() -> QueryFilterNode.invalidWhereClauseException("Like condition on non-existent column " + String.valueOf(columnName), QueryFilterNode.this.isWindowed));
                if (SqlBaseType.STRING != col.type().baseType()) {
                    throw QueryFilterNode.invalidWhereClauseException("The column type for Like condition must be VARCHAR. The column type is " + col.type().baseType().toString(), QueryFilterNode.this.isWindowed);
                }
                Expression pattern = node.getPattern();
                if (!(pattern instanceof StringLiteral) && !(pattern instanceof NullLiteral)) {
                    throw QueryFilterNode.invalidWhereClauseException("Like condition on non-string pattern " + pattern.getClass().getName(), QueryFilterNode.this.isWindowed);
                }
            } else {
                this.setTableScanOrElseThrow(() -> QueryFilterNode.invalidWhereClauseException("Like condition must be between strings", QueryFilterNode.this.isWindowed));
            }
            return null;
        }

        private boolean isKeyQuery(ComparisonExpression node) {
            return node.getType() != ComparisonExpression.Type.NOT_EQUAL && node.getType() != ComparisonExpression.Type.IS_DISTINCT_FROM && node.getType() != ComparisonExpression.Type.IS_NOT_DISTINCT_FROM;
        }

        private void setTableScanOrElseThrow(Supplier<KsqlException> exceptionSupplier) {
            if (!QueryFilterNode.this.queryPlannerOptions.getTableScansEnabled()) {
                throw exceptionSupplier.get();
            }
            this.requiresTableScan = true;
        }
    }

    private final class KeyAndSystemColsExtractor
    extends TraversalExpressionVisitor<Object> {
        private KeyAndSystemColsExtractor() {
        }

        public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Object context) {
            Optional col = QueryFilterNode.this.schema.findColumn(node.getColumnName());
            if (col.isPresent() && ((Column)col.get()).namespace() == Column.Namespace.KEY) {
                QueryFilterNode.this.keyColumns.add(node);
            } else if (SystemColumns.isSystemColumn((ColumnName)node.getColumnName())) {
                QueryFilterNode.this.systemColumns.add(node);
            }
            return null;
        }
    }

    private final class KeyValueExtractor
    extends TraversalExpressionVisitor<Object> {
        private final BitSet seenKeys;
        private final Object[] keyContents;
        private HashMap<Integer, ImmutablePair<ComparisonExpression.Type, SqlType>> operators;

        KeyValueExtractor() {
            this.keyContents = new Object[QueryFilterNode.this.schema.key().size()];
            this.seenKeys = new BitSet(QueryFilterNode.this.schema.key().size());
            this.operators = new HashMap();
        }

        public Void visitComparisonExpression(ComparisonExpression node, Object context) {
            UnqualifiedColumnReferenceExp column = QueryFilterNode.this.getColumnRefSideOrNull(node);
            Expression other = QueryFilterNode.this.getNonColumnRefSide(node);
            Preconditions.checkNotNull((Object)column, (Object)"UnqualifiedColumnReferenceExp should be found");
            ColumnName columnName = column.getColumnName();
            Optional col = QueryFilterNode.this.schema.findColumn(columnName);
            if (col.isPresent() && ((Column)col.get()).namespace() == Column.Namespace.KEY) {
                Object key = this.resolveKey(other, (Column)col.get(), QueryFilterNode.this.metaStore, QueryFilterNode.this.ksqlConfig, (Expression)node);
                this.setMostSelectiveConstraint((Column)col.get(), node, key);
            }
            return null;
        }

        public LookupConstraint getLookupConstraint(Optional<WindowBounds> windowBounds) {
            if (this.seenKeys.isEmpty()) {
                return new NonKeyConstraint();
            }
            if (this.operators.size() > 1) {
                if (this.operators.values().stream().allMatch(op -> ((ComparisonExpression.Type)op.getKey()).equals((Object)ComparisonExpression.Type.EQUAL))) {
                    return new KeyConstraint(KeyConstraint.ConstraintOperator.EQUAL, GenericKey.fromArray((Object[])this.keyContents), windowBounds);
                }
                return new NonKeyConstraint();
            }
            ComparisonExpression.Type operatorType = (ComparisonExpression.Type)this.operators.get(0).getLeft();
            if (operatorType == ComparisonExpression.Type.EQUAL) {
                return new KeyConstraint(KeyConstraint.ConstraintOperator.EQUAL, GenericKey.fromArray((Object[])this.keyContents), windowBounds);
            }
            if (this.isSupportedType((SqlType)this.operators.get(0).getRight())) {
                if (operatorType == ComparisonExpression.Type.GREATER_THAN) {
                    return new KeyConstraint(KeyConstraint.ConstraintOperator.GREATER_THAN, GenericKey.fromArray((Object[])this.keyContents), windowBounds);
                }
                if (operatorType == ComparisonExpression.Type.GREATER_THAN_OR_EQUAL) {
                    return new KeyConstraint(KeyConstraint.ConstraintOperator.GREATER_THAN_OR_EQUAL, GenericKey.fromArray((Object[])this.keyContents), windowBounds);
                }
                if (operatorType == ComparisonExpression.Type.LESS_THAN) {
                    return new KeyConstraint(KeyConstraint.ConstraintOperator.LESS_THAN, GenericKey.fromArray((Object[])this.keyContents), windowBounds);
                }
                if (operatorType == ComparisonExpression.Type.LESS_THAN_OR_EQUAL) {
                    return new KeyConstraint(KeyConstraint.ConstraintOperator.LESS_THAN_OR_EQUAL, GenericKey.fromArray((Object[])this.keyContents), windowBounds);
                }
            }
            return new NonKeyConstraint();
        }

        private boolean isSupportedType(SqlType sqlType) {
            if (sqlType == SqlTypes.STRING) {
                return true;
            }
            return sqlType == SqlTypes.BYTES;
        }

        private Object resolveKey(Expression exp, Column keyColumn, MetaStore metaStore, KsqlConfig config, Expression errorMessageHint) {
            Object obj = exp instanceof NullLiteral ? null : (exp instanceof Literal ? ((Literal)exp).getValue() : new GenericExpressionResolver(keyColumn.type(), keyColumn.name(), (FunctionRegistry)metaStore, config, "pull query", QueryFilterNode.this.queryPlannerOptions.getInterpreterEnabled()).resolve(exp));
            if (obj == null) {
                throw new KsqlException("Primary key columns can not be NULL: " + String.valueOf(errorMessageHint));
            }
            return DefaultSqlValueCoercer.STRICT.coerce(obj, keyColumn.type()).orElseThrow(() -> new KsqlException("'" + String.valueOf(obj) + "' can not be converted to the type of the key column: " + keyColumn.toString(FormatOptions.noEscape()))).orElse(null);
        }

        private void setMostSelectiveConstraint(Column col, ComparisonExpression node, Object key) {
            int index = col.index();
            if (this.operators.containsKey(index) && this.operators.get(index).getLeft() == ComparisonExpression.Type.EQUAL) {
                return;
            }
            if (node.getType() == ComparisonExpression.Type.EQUAL) {
                this.setConstraint(index, col, node, key);
                return;
            }
            if (!this.operators.containsKey(index)) {
                this.setConstraint(index, col, node, key);
            }
        }

        private void setConstraint(int index, Column col, ComparisonExpression node, Object key) {
            this.keyContents[index] = key;
            this.seenKeys.set(index);
            this.operators.put(index, (ImmutablePair<ComparisonExpression.Type, SqlType>)new ImmutablePair((Object)node.getType(), (Object)col.type()));
        }
    }

    public static final class WindowBounds {
        private WindowRange start;
        private WindowRange end;

        public WindowBounds(WindowRange start, WindowRange end) {
            this.start = Objects.requireNonNull(start, "startBounds");
            this.end = Objects.requireNonNull(end, "endBounds");
        }

        public WindowBounds() {
            this.start = new WindowRange();
            this.end = new WindowRange();
        }

        boolean setEquality(UnqualifiedColumnReferenceExp column, Range<Instant> range) {
            if (column.getColumnName().equals((Object)SystemColumns.WINDOWSTART_NAME)) {
                if (this.start.equal != null) {
                    return false;
                }
                this.start.equal = range;
            } else {
                if (this.end.equal != null) {
                    return false;
                }
                this.end.equal = range;
            }
            return true;
        }

        boolean setUpper(UnqualifiedColumnReferenceExp column, Range<Instant> range) {
            if (column.getColumnName().equals((Object)SystemColumns.WINDOWSTART_NAME)) {
                if (this.start.upper != null) {
                    return false;
                }
                this.start.upper = range;
            } else {
                if (this.end.upper != null) {
                    return false;
                }
                this.end.upper = range;
            }
            return true;
        }

        boolean setLower(UnqualifiedColumnReferenceExp column, Range<Instant> range) {
            if (column.getColumnName().equals((Object)SystemColumns.WINDOWSTART_NAME)) {
                if (this.start.lower != null) {
                    return false;
                }
                this.start.lower = range;
            } else {
                if (this.end.lower != null) {
                    return false;
                }
                this.end.lower = range;
            }
            return true;
        }

        public WindowRange getStart() {
            return this.start;
        }

        public WindowRange getEnd() {
            return this.end;
        }

        public Range<Instant> getMergedStart() {
            return this.start.getMergedRange();
        }

        public Range<Instant> getMergedEnd() {
            return this.end.getMergedRange();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WindowBounds that = (WindowBounds)o;
            return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return "WindowBounds{start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
        }

        static final class WindowRange {
            private Range<Instant> equal;
            private Range<Instant> upper;
            private Range<Instant> lower;

            WindowRange(Range<Instant> equal, Range<Instant> upper, Range<Instant> lower) {
                this.equal = equal;
                this.upper = upper;
                this.lower = lower;
            }

            WindowRange() {
            }

            public Range<Instant> getEqual() {
                return this.equal;
            }

            public Range<Instant> getUpper() {
                return this.upper;
            }

            public Range<Instant> getLower() {
                return this.lower;
            }

            Range<Instant> getMergedRange() {
                if (this.lower == null && this.upper == null && this.equal == null) {
                    return Range.all();
                }
                if (this.lower != null && this.upper != null) {
                    return Range.range((Comparable)((Instant)this.lower.lowerEndpoint()), (BoundType)this.lower.lowerBoundType(), (Comparable)((Instant)this.upper.upperEndpoint()), (BoundType)this.upper.upperBoundType());
                }
                if (this.upper != null) {
                    return this.upper;
                }
                if (this.lower != null) {
                    return this.lower;
                }
                return this.equal;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                WindowRange that = (WindowRange)o;
                return Objects.equals(this.equal, that.equal) && Objects.equals(this.upper, that.upper) && Objects.equals(this.lower, that.lower);
            }

            public int hashCode() {
                return Objects.hash(this.equal, this.upper, this.lower);
            }

            public String toString() {
                return "WindowRange{equal=" + String.valueOf(this.equal) + ", upper=" + String.valueOf(this.upper) + ", lower=" + String.valueOf(this.lower) + "}";
            }
        }
    }

    private final class WindowBoundsExtractor
    extends TraversalExpressionVisitor<WindowBounds> {
        private WindowBoundsExtractor() {
        }

        public Void visitComparisonExpression(ComparisonExpression node, WindowBounds windowBounds) {
            ComparisonExpression.Type type;
            UnqualifiedColumnReferenceExp column;
            if (node.getRight() instanceof UnqualifiedColumnReferenceExp) {
                column = (UnqualifiedColumnReferenceExp)node.getRight();
            } else if (node.getLeft() instanceof UnqualifiedColumnReferenceExp) {
                column = (UnqualifiedColumnReferenceExp)node.getLeft();
            } else {
                return null;
            }
            if (!column.getColumnName().equals((Object)SystemColumns.WINDOWSTART_NAME) && !column.getColumnName().equals((Object)SystemColumns.WINDOWEND_NAME)) {
                return null;
            }
            boolean result = false;
            if (node.getType().equals((Object)ComparisonExpression.Type.EQUAL)) {
                Range instant = Range.singleton((Comparable)this.asInstant(this.getNonColumnRefSide(node), column.getColumnName()));
                result = windowBounds.setEquality(column, (Range<Instant>)instant);
            }
            if ((type = this.getSimplifiedBoundType(node)).equals((Object)ComparisonExpression.Type.LESS_THAN)) {
                Instant upper = this.asInstant(this.getNonColumnRefSide(node), column.getColumnName());
                BoundType upperType = this.getRangeBoundType(node);
                result = windowBounds.setUpper(column, (Range<Instant>)Range.upTo((Comparable)upper, (BoundType)upperType));
            } else if (type.equals((Object)ComparisonExpression.Type.GREATER_THAN)) {
                Instant lower = this.asInstant(this.getNonColumnRefSide(node), column.getColumnName());
                BoundType lowerType = this.getRangeBoundType(node);
                result = windowBounds.setLower(column, (Range<Instant>)Range.downTo((Comparable)lower, (BoundType)lowerType));
            }
            this.validateEqualityBound(windowBounds, node, column);
            if (!result) {
                throw QueryFilterNode.invalidWhereClauseException("Duplicate " + String.valueOf(column.getColumnName()) + " bounds on: " + String.valueOf(type), true);
            }
            return null;
        }

        private void validateEqualityBound(WindowBounds bound, ComparisonExpression expression, UnqualifiedColumnReferenceExp column) {
            if (column.getColumnName().equals((Object)SystemColumns.WINDOWSTART_NAME) ? bound.getStart().getEqual() != null && (bound.getStart().getUpper() != null || bound.getStart().getLower() != null) : bound.getEnd().getEqual() != null && (bound.getEnd().getUpper() != null || bound.getEnd().getLower() != null)) {
                throw QueryFilterNode.invalidWhereClauseException("`" + String.valueOf(expression) + "` cannot be combined with other " + String.valueOf(column.getColumnName()) + " bounds", true);
            }
        }

        private ComparisonExpression.Type getSimplifiedBoundType(ComparisonExpression comparison) {
            ComparisonExpression.Type type = comparison.getType();
            boolean inverted = comparison.getRight() instanceof UnqualifiedColumnReferenceExp;
            switch (type) {
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    return inverted ? ComparisonExpression.Type.GREATER_THAN : ComparisonExpression.Type.LESS_THAN;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    return inverted ? ComparisonExpression.Type.LESS_THAN : ComparisonExpression.Type.GREATER_THAN;
                }
            }
            return type;
        }

        private Expression getNonColumnRefSide(ComparisonExpression comparison) {
            return comparison.getRight() instanceof UnqualifiedColumnReferenceExp ? comparison.getLeft() : comparison.getRight();
        }

        private Instant asInstant(Expression other, ColumnName name) {
            if (other instanceof IntegerLiteral) {
                return Instant.ofEpochMilli(((IntegerLiteral)other).getValue().intValue());
            }
            if (other instanceof LongLiteral) {
                return Instant.ofEpochMilli(((LongLiteral)other).getValue());
            }
            if (other instanceof StringLiteral) {
                String text = ((StringLiteral)other).getValue();
                try {
                    long timestamp = new PartialStringToTimestampParser().parse(text);
                    return Instant.ofEpochMilli(timestamp);
                }
                catch (Exception e) {
                    throw QueryFilterNode.invalidWhereClauseException("Failed to parse datetime: " + text, true);
                }
            }
            try {
                Long value = (Long)new GenericExpressionResolver((SqlType)SqlTypes.BIGINT, name, (FunctionRegistry)QueryFilterNode.this.metaStore, QueryFilterNode.this.ksqlConfig, "pull query window bounds extractor", QueryFilterNode.this.queryPlannerOptions.getInterpreterEnabled()).resolve(other);
                return Instant.ofEpochMilli(value);
            }
            catch (KsqlException e) {
                throw QueryFilterNode.invalidWhereClauseException("Window bounds must resolve to an INT, BIGINT, or STRING containing a datetime.", true);
            }
        }

        private BoundType getRangeBoundType(ComparisonExpression lowerComparison) {
            boolean openBound = lowerComparison.getType() == ComparisonExpression.Type.LESS_THAN || lowerComparison.getType() == ComparisonExpression.Type.GREATER_THAN;
            return openBound ? BoundType.OPEN : BoundType.CLOSED;
        }
    }

    private static final class HasColumnRef
    extends TraversalExpressionVisitor<Object> {
        private boolean hasColumnRef = false;

        HasColumnRef() {
        }

        public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Object context) {
            this.hasColumnRef = true;
            return null;
        }

        public boolean hasColumnRef() {
            return this.hasColumnRef;
        }
    }
}

