/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MissingSubjectClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LogManager.getLogger(MissingSubjectClassifier.class);
    private final String queryId;

    public MissingSubjectClassifier(String queryId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public QueryError.Type classify(Throwable e) {
        QueryError.Type type;
        QueryError.Type type2 = type = SchemaRegistryUtil.isSubjectNotFoundErrorCode(e) ? QueryError.Type.USER : QueryError.Type.UNKNOWN;
        if (type == QueryError.Type.USER) {
            LOG.info("Classified error as USER error based on missing SR subject. Query ID: {} Exception: {}", (Object)this.queryId, (Object)e);
        }
        return type;
    }
}

