/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.query.BlockingRowQueue;
import io.confluent.ksql.query.CompletionHandler;
import io.confluent.ksql.query.LimitHandler;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.KeyValueMetadata;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TransientQueryQueue
implements BlockingRowQueue {
    public static final int BLOCKING_QUEUE_CAPACITY = 500;
    private final BlockingQueue<KeyValueMetadata<List<?>, GenericRow>> rowQueue;
    private final int offerTimeoutMs;
    private volatile boolean closed = false;
    private final AtomicInteger remaining;
    private LimitHandler limitHandler;
    private CompletionHandler completionHandler;
    private Runnable queuedCallback;
    private AtomicLong totalRowsQueued = new AtomicLong(0L);
    private AtomicBoolean invokedHandler = new AtomicBoolean(false);

    public TransientQueryQueue(OptionalInt limit) {
        this(limit, 500, 100);
    }

    @VisibleForTesting
    public TransientQueryQueue(OptionalInt limit, int queueSizeLimit, int offerTimeoutMs) {
        this.remaining = limit.isPresent() ? new AtomicInteger(limit.getAsInt()) : null;
        this.rowQueue = new LinkedBlockingQueue(queueSizeLimit);
        this.offerTimeoutMs = offerTimeoutMs;
    }

    @Override
    public void setQueuedCallback(Runnable queuedCallback) {
        this.queuedCallback = queuedCallback;
    }

    @Override
    public void setLimitHandler(LimitHandler limitHandler) {
        this.limitHandler = limitHandler;
        if (this.passedLimit()) {
            this.invokedHandler.set(true);
            limitHandler.limitReached();
        }
    }

    @Override
    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.completionHandler = completionHandler;
    }

    @Override
    public KeyValueMetadata<List<?>, GenericRow> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.rowQueue.poll(timeout, unit);
    }

    @Override
    public KeyValueMetadata<List<?>, GenericRow> poll() {
        return (KeyValueMetadata)this.rowQueue.poll();
    }

    @Override
    public void drainTo(Collection<? super KeyValueMetadata<List<?>, GenericRow>> collection) {
        this.rowQueue.drainTo(collection);
    }

    @Override
    public int size() {
        return this.rowQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rowQueue.isEmpty();
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.invokedHandler.compareAndSet(false, true)) {
            this.complete();
        }
    }

    public void acceptRow(List<?> key, GenericRow value) {
        try {
            if (this.passedLimit()) {
                return;
            }
            KeyValue row = KeyValue.keyValue(key, (Object)value);
            KeyValueMetadata keyValueMetadata = new KeyValueMetadata(row);
            while (!this.closed) {
                if (!this.rowQueue.offer(keyValueMetadata, this.offerTimeoutMs, TimeUnit.MILLISECONDS)) continue;
                this.onQueued();
                this.totalRowsQueued.incrementAndGet();
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean acceptRowNonBlocking(KeyValueMetadata<List<?>, GenericRow> keyValueMetadata) {
        try {
            if (this.passedLimit()) {
                return true;
            }
            if (!this.closed) {
                if (!this.rowQueue.offer(keyValueMetadata, 0L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
                this.onQueued();
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void complete() {
        if (this.completionHandler != null) {
            this.completionHandler.complete();
        }
    }

    private void onQueued() {
        if (this.remaining != null && this.remaining.decrementAndGet() <= 0) {
            this.invokedHandler.set(true);
            this.limitHandler.limitReached();
        }
        if (this.queuedCallback != null) {
            this.queuedCallback.run();
        }
    }

    private boolean passedLimit() {
        return this.remaining != null && this.remaining.get() <= 0;
    }

    public long getTotalRowsQueued() {
        return this.totalRowsQueued.get();
    }
}

