/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.inference;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.execution.ddl.commands.CreateSourceCommand;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.properties.with.SourcePropertiesUtil;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.inference.TopicSchemaSupplier;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.services.SandboxedServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.ErrorMessageUtil;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlSchemaRegistryNotConfiguredException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaRegisterInjector
implements Injector {
    private final KsqlExecutionContext executionContext;
    private final ServiceContext serviceContext;

    public SchemaRegisterInjector(KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        this.executionContext = Objects.requireNonNull(executionContext, "executionContext");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
    }

    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        try {
            if (statement.getStatement() instanceof CreateAsSelect) {
                this.registerForCreateAs(statement);
            } else if (statement.getStatement() instanceof CreateSource) {
                this.registerForCreateSource(statement);
            }
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(ErrorMessageUtil.buildErrorMessage((Throwable)e), statement.getMaskedStatementText(), e.getCause());
        }
        return this.stripSchemaIdConfig(statement);
    }

    private <T extends Statement> ConfiguredStatement<T> stripSchemaIdConfig(ConfiguredStatement<T> statement) {
        Map overrides = statement.getSessionConfig().getOverrides();
        if (!overrides.containsKey("KEY_SCHEMA_ID") && !overrides.containsKey("VALUE_SCHEMA_ID")) {
            return statement;
        }
        ImmutableMap newOverrides = (ImmutableMap)overrides.entrySet().stream().filter(e -> !((String)e.getKey()).equals("KEY_SCHEMA_ID") && !((String)e.getKey()).equals("VALUE_SCHEMA_ID")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return ConfiguredStatement.of(statement.getPreparedStatement(), statement.getSessionConfig().withNewOverrides((Map)newOverrides));
    }

    private void registerForCreateSource(ConfiguredStatement<? extends CreateSource> cs) {
        CreateSource statement = cs.getStatement();
        LogicalSchema schema = statement.getElements().toLogicalSchema();
        FormatInfo keyFormatInfo = SourcePropertiesUtil.getKeyFormat((CreateSourceProperties)statement.getProperties(), (SourceName)statement.getName());
        Format keyFormat = SchemaRegisterInjector.tryGetFormat(keyFormatInfo, true, cs.getMaskedStatementText());
        SerdeFeatures keyFeatures = SerdeFeaturesFactory.buildKeyFeatures(schema, keyFormat);
        FormatInfo valueFormatInfo = SourcePropertiesUtil.getValueFormat((CreateSourceProperties)statement.getProperties());
        Format valueFormat = SchemaRegisterInjector.tryGetFormat(valueFormatInfo, false, cs.getMaskedStatementText());
        SerdeFeatures valFeatures = SerdeFeaturesFactory.buildValueFeatures(schema, valueFormat, statement.getProperties().getValueSerdeFeatures(), cs.getSessionConfig().getConfig(false));
        TopicSchemaSupplier.SchemaAndId rawKeySchema = (TopicSchemaSupplier.SchemaAndId)cs.getSessionConfig().getOverrides().get("KEY_SCHEMA_ID");
        TopicSchemaSupplier.SchemaAndId rawValueSchema = (TopicSchemaSupplier.SchemaAndId)cs.getSessionConfig().getOverrides().get("VALUE_SCHEMA_ID");
        this.registerSchemas(schema, (Pair<TopicSchemaSupplier.SchemaAndId, TopicSchemaSupplier.SchemaAndId>)Pair.of((Object)rawKeySchema, (Object)rawValueSchema), statement.getProperties().getKafkaTopic(), keyFormatInfo, keyFeatures, valueFormatInfo, valFeatures, cs.getSessionConfig().getConfig(false), cs.getMaskedStatementText(), false);
    }

    private static Format tryGetFormat(FormatInfo formatInfo, boolean isKey, String statementText) {
        try {
            return FormatFactory.of((FormatInfo)formatInfo);
        }
        catch (KsqlException e) {
            if (e.getMessage().contains("does not support the following configs: [schemaId]")) {
                String idMsg = isKey ? "KEY_SCHEMA_ID" : "VALUE_SCHEMA_ID";
                throw new KsqlStatementException(idMsg + " is provided but format " + formatInfo.getFormat() + " doesn't support registering in Schema Registry", statementText, (Throwable)e);
            }
            throw e;
        }
    }

    private void registerForCreateAs(ConfiguredStatement<? extends CreateAsSelect> cas) {
        CreateSourceCommand createSourceCommand;
        try {
            SandboxedServiceContext sandboxServiceContext = SandboxedServiceContext.create(this.serviceContext);
            createSourceCommand = (CreateSourceCommand)this.executionContext.createSandbox(sandboxServiceContext).plan(sandboxServiceContext, cas).getDdlCommand().get();
        }
        catch (KsqlStatementException e) {
            throw new KsqlStatementException("Could not determine output schema for query due to error: " + e.getMessage(), "Could not determine output schema for query due to error: " + e.getUnloggedMessage(), cas.getMaskedStatementText(), (Throwable)e);
        }
        catch (Exception e) {
            throw new KsqlStatementException("Could not determine output schema for query due to error: " + e.getMessage(), cas.getMaskedStatementText(), (Throwable)e);
        }
        TopicSchemaSupplier.SchemaAndId rawKeySchema = (TopicSchemaSupplier.SchemaAndId)cas.getSessionConfig().getOverrides().get("KEY_SCHEMA_ID");
        TopicSchemaSupplier.SchemaAndId rawValueSchema = (TopicSchemaSupplier.SchemaAndId)cas.getSessionConfig().getOverrides().get("VALUE_SCHEMA_ID");
        this.registerSchemas(createSourceCommand.getSchema(), (Pair<TopicSchemaSupplier.SchemaAndId, TopicSchemaSupplier.SchemaAndId>)Pair.of((Object)rawKeySchema, (Object)rawValueSchema), createSourceCommand.getTopicName(), createSourceCommand.getFormats().getKeyFormat(), createSourceCommand.getFormats().getKeyFeatures(), createSourceCommand.getFormats().getValueFormat(), createSourceCommand.getFormats().getValueFeatures(), cas.getSessionConfig().getConfig(false), cas.getMaskedStatementText(), true);
    }

    private void registerSchemas(LogicalSchema schema, Pair<TopicSchemaSupplier.SchemaAndId, TopicSchemaSupplier.SchemaAndId> kvRawSchema, String kafkaTopic, FormatInfo keyFormat, SerdeFeatures keySerdeFeatures, FormatInfo valueFormat, SerdeFeatures valueSerdeFeatures, KsqlConfig config, String statementText, boolean registerIfSchemaExists) {
        boolean registerRawValue;
        boolean registerRawKey = kvRawSchema.left != null;
        boolean bl = registerRawValue = kvRawSchema.right != null;
        if (!registerRawKey) {
            this.registerSchema(schema.key(), kafkaTopic, keyFormat, keySerdeFeatures, config, statementText, registerIfSchemaExists, KsqlConstants.getSRSubject((String)kafkaTopic, (boolean)true), true);
        }
        if (!registerRawValue) {
            this.registerSchema(schema.value(), kafkaTopic, valueFormat, valueSerdeFeatures, config, statementText, registerIfSchemaExists, KsqlConstants.getSRSubject((String)kafkaTopic, (boolean)false), false);
        }
        if (registerRawKey) {
            SchemaRegisterInjector.sanityCheck((TopicSchemaSupplier.SchemaAndId)kvRawSchema.left, keyFormat, kafkaTopic, config, statementText, true);
        }
        if (registerRawValue) {
            SchemaRegisterInjector.sanityCheck((TopicSchemaSupplier.SchemaAndId)kvRawSchema.right, valueFormat, kafkaTopic, config, statementText, false);
        }
        if (registerRawKey) {
            this.registerRawSchema((TopicSchemaSupplier.SchemaAndId)kvRawSchema.left, kafkaTopic, statementText, KsqlConstants.getSRSubject((String)kafkaTopic, (boolean)true), true);
        }
        if (registerRawValue) {
            this.registerRawSchema((TopicSchemaSupplier.SchemaAndId)kvRawSchema.right, kafkaTopic, statementText, KsqlConstants.getSRSubject((String)kafkaTopic, (boolean)false), false);
        }
    }

    private static void sanityCheck(TopicSchemaSupplier.SchemaAndId schemaAndId, FormatInfo formatInfo, String topic, KsqlConfig config, String statementText, boolean isKey) {
        String schemaIdPropStr = isKey ? "KEY_SCHEMA_ID" : "VALUE_SCHEMA_ID";
        Format format = FormatFactory.of((FormatInfo)formatInfo);
        if (!SchemaRegisterInjector.canRegister(format, config, topic)) {
            throw new KsqlStatementException(schemaIdPropStr + " is provided but format " + format.name() + " doesn't support registering in Schema Registry", statementText);
        }
        SchemaTranslator translator = format.getSchemaTranslator(formatInfo.getProperties());
        if (!translator.name().equals(schemaAndId.rawSchema.schemaType())) {
            throw new KsqlStatementException(String.format("Format and fetched schema type using %s %d are different. Format: [%s], Fetched schema type: [%s].", schemaIdPropStr, schemaAndId.id, format.name(), schemaAndId.rawSchema.schemaType()), statementText);
        }
    }

    private void registerRawSchema(TopicSchemaSupplier.SchemaAndId schemaAndId, String topic, String statementText, String subject, Boolean isKey) {
        int id;
        try {
            id = SchemaRegistryUtil.registerSchema(this.serviceContext.getSchemaRegistryClient(), schemaAndId.rawSchema, topic, subject, isKey);
        }
        catch (KsqlException e) {
            throw new KsqlStatementException("Could not register schema for topic: " + e.getMessage(), statementText, (Throwable)e);
        }
        boolean isSandbox = this.serviceContext instanceof SandboxedServiceContext;
        if (!isSandbox && id != schemaAndId.id) {
            String schemaIdPropStr = isKey != false ? "KEY_SCHEMA_ID" : "VALUE_SCHEMA_ID";
            throw new KsqlStatementException("Schema id registered is " + id + " which is different from provided " + schemaIdPropStr + " " + schemaAndId.id + "." + System.lineSeparator() + "Topic: " + topic + System.lineSeparator() + "Subject: " + subject + System.lineSeparator() + "Schema: " + String.valueOf(schemaAndId.rawSchema), statementText);
        }
    }

    private static boolean canRegister(Format format, KsqlConfig config, String topic) {
        if (!format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
            return false;
        }
        if (config.getString("ksql.schema.registry.url").isEmpty()) {
            throw new KsqlSchemaRegistryNotConfiguredException(String.format("Cannot create topic '%s' with format %s without configuring '%s'", topic, format.name(), "ksql.schema.registry.url"));
        }
        return true;
    }

    private void registerSchema(List<? extends SimpleColumn> schema, String topic, FormatInfo formatInfo, SerdeFeatures serdeFeatures, KsqlConfig config, String statementText, boolean registerIfSchemaExists, String subject, boolean isKey) {
        Format format = FormatFactory.of((FormatInfo)formatInfo);
        if (!SchemaRegisterInjector.canRegister(format, config, topic)) {
            return;
        }
        SchemaRegistryClient srClient = this.serviceContext.getSchemaRegistryClient();
        if (registerIfSchemaExists || !SchemaRegistryUtil.subjectExists(srClient, subject)) {
            try {
                SchemaTranslator translator = format.getSchemaTranslator(formatInfo.getProperties());
                ParsedSchema parsedSchema = translator.toParsedSchema(PersistenceSchema.from(schema, (SerdeFeatures)serdeFeatures));
                SchemaRegistryUtil.registerSchema(srClient, parsedSchema, topic, subject, isKey);
            }
            catch (KsqlException e) {
                throw new KsqlStatementException("Could not register schema for topic: " + e.getMessage(), statementText, (Throwable)e);
            }
        }
    }
}

