/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.security.KsqlPrincipal;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class DefaultKsqlPrincipal
implements KsqlPrincipal {
    private final Principal principal;
    private final String ipAddress;
    private final int port;

    public DefaultKsqlPrincipal(Principal principal) {
        this(principal, "", 0);
    }

    protected DefaultKsqlPrincipal(Principal principal, String ipAddress, int port) {
        this.principal = Objects.requireNonNull(principal, "principal");
        this.ipAddress = Objects.requireNonNull(ipAddress, "ipAddress");
        this.port = port;
    }

    @Override
    public String getName() {
        return this.principal.getName();
    }

    @Override
    public Map<String, Object> getUserProperties() {
        if (this.principal instanceof KsqlPrincipal) {
            return ((KsqlPrincipal)this.principal).getUserProperties();
        }
        return Collections.emptyMap();
    }

    public Principal getOriginalPrincipal() {
        return this.principal;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public DefaultKsqlPrincipal withIpAddressAndPort(String ipAddress, int port) {
        return new DefaultKsqlPrincipal(this.principal, ipAddress, port);
    }
}

