/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Stack;

public final class ExtensionSecurityManager
extends SecurityManager {
    public static final ExtensionSecurityManager INSTANCE = new ExtensionSecurityManager();
    private static final ThreadLocal<Stack<Boolean>> UDF_IS_EXECUTING = new ThreadLocal();

    private ExtensionSecurityManager() {
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions permissions = new Permissions();
                permissions.add(new AllPermission());
                return permissions;
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain domain) {
                return this.getPermissions(domain.getCodeSource());
            }

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                return true;
            }
        });
    }

    public synchronized void pushInUdf() {
        if (UDF_IS_EXECUTING.get() == null) {
            UDF_IS_EXECUTING.set(new Stack());
        }
        UDF_IS_EXECUTING.get().push(true);
    }

    public void popOutUdf() {
        Stack<Boolean> stack = UDF_IS_EXECUTING.get();
        if (stack != null && !stack.isEmpty()) {
            stack.pop();
        }
    }

    @Override
    public void checkExit(int status) {
        if (this.inUdfExecution()) {
            throw new SecurityException("A UDF attempted to call System.exit");
        }
        super.checkExit(status);
    }

    @Override
    public void checkExec(String cmd) {
        if (this.inUdfExecution()) {
            throw new SecurityException("A UDF attempted to execute the following cmd: " + cmd);
        }
        super.checkExec(cmd);
    }

    private boolean inUdfExecution() {
        Stack<Boolean> executing = UDF_IS_EXECUTING.get();
        return executing != null && !executing.isEmpty();
    }
}

