/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.security.KsqlAccessValidator;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.KsqlAuthorizationValidator;
import io.confluent.ksql.security.KsqlAuthorizationValidatorImpl;
import io.confluent.ksql.security.KsqlBackendAccessValidator;
import io.confluent.ksql.security.KsqlCacheAccessValidator;
import io.confluent.ksql.security.KsqlProvidedAccessValidator;
import io.confluent.ksql.services.KafkaClusterUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlServerException;
import java.util.Optional;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KsqlAuthorizationValidatorFactory {
    private static final Logger LOG = LogManager.getLogger(KsqlAuthorizationValidatorFactory.class);
    private static final String KAFKA_AUTHORIZER_CLASS_NAME = "authorizer.class.name";

    private KsqlAuthorizationValidatorFactory() {
    }

    public static Optional<KsqlAuthorizationValidator> create(KsqlConfig ksqlConfig, ServiceContext serviceContext, Optional<KsqlAuthorizationProvider> externalAuthorizationProvider) {
        Optional<KsqlAccessValidator> accessValidator = KsqlAuthorizationValidatorFactory.getAccessValidator(ksqlConfig, serviceContext, externalAuthorizationProvider);
        return accessValidator.map(v -> new KsqlAuthorizationValidatorImpl(KsqlAuthorizationValidatorFactory.cacheIfEnabled(ksqlConfig, v)));
    }

    private static Optional<KsqlAccessValidator> getAccessValidator(KsqlConfig ksqlConfig, ServiceContext serviceContext, Optional<KsqlAuthorizationProvider> externalAuthorizationProvider) {
        String featureFlag = ksqlConfig.getString("ksql.access.validator.enable");
        if (featureFlag.equalsIgnoreCase("off")) {
            return Optional.empty();
        }
        if (externalAuthorizationProvider.isPresent()) {
            return Optional.of(new KsqlProvidedAccessValidator(externalAuthorizationProvider.get()));
        }
        if (KsqlAuthorizationValidatorFactory.isTopicAccessValidatorEnabled(ksqlConfig, serviceContext)) {
            return Optional.of(new KsqlBackendAccessValidator());
        }
        return Optional.empty();
    }

    private static KsqlAccessValidator cacheIfEnabled(KsqlConfig ksqlConfig, KsqlAccessValidator accessValidator) {
        return KsqlAuthorizationValidatorFactory.isCacheEnabled(ksqlConfig) ? new KsqlCacheAccessValidator(ksqlConfig, accessValidator) : accessValidator;
    }

    private static boolean isCacheEnabled(KsqlConfig ksqlConfig) {
        return ksqlConfig.getLong("ksql.authorization.cache.expiry.time.secs") > 0L;
    }

    private static boolean isTopicAccessValidatorEnabled(KsqlConfig ksqlConfig, ServiceContext serviceContext) {
        String enabled = ksqlConfig.getString("ksql.access.validator.enable");
        if (enabled.equals("on")) {
            return true;
        }
        Admin adminClient = serviceContext.getAdminClient();
        if (KsqlAuthorizationValidatorFactory.isKafkaAuthorizerEnabled(adminClient)) {
            if (KafkaClusterUtil.isAuthorizedOperationsSupported(adminClient)) {
                LOG.info("KSQL topic authorization checks enabled.");
                return true;
            }
            LOG.warn("The Kafka broker has an authorization service enabled, but the Kafka version does not support authorizedOperations(). KSQL topic authorization checks will not be enabled.");
        }
        return false;
    }

    private static boolean isKafkaAuthorizerEnabled(Admin adminClient) {
        try {
            ConfigEntry configEntry = KafkaClusterUtil.getConfig(adminClient).get(KAFKA_AUTHORIZER_CLASS_NAME);
            return configEntry != null && configEntry.value() != null && !configEntry.value().isEmpty();
        }
        catch (KsqlServerException e) {
            if (e.getCause() instanceof ClusterAuthorizationException) {
                return true;
            }
            throw e;
        }
    }
}

