/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.connect.ConnectRequestHeadersExtension;
import io.confluent.ksql.security.KsqlPrincipal;
import io.confluent.ksql.services.ConnectClientFactory;
import io.confluent.ksql.services.DefaultConnectClient;
import io.confluent.ksql.util.FileWatcher;
import io.confluent.ksql.util.KsqlConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConnectClientFactory
implements ConnectClientFactory {
    private static final Logger log = LogManager.getLogger(DefaultConnectClientFactory.class);
    private final KsqlConfig ksqlConfig;
    private final Optional<ConnectRequestHeadersExtension> requestHeadersExtension;
    private volatile Optional<String> defaultConnectAuthHeader;
    private FileWatcher credentialsFileWatcher;

    public DefaultConnectClientFactory(KsqlConfig ksqlConfig) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.requestHeadersExtension = Optional.ofNullable((ConnectRequestHeadersExtension)ksqlConfig.getConfiguredInstance("ksql.connect.request.headers.plugin", ConnectRequestHeadersExtension.class));
    }

    @Override
    public synchronized DefaultConnectClient get(Optional<String> ksqlAuthHeader, List<Map.Entry<String, String>> incomingRequestHeaders, Optional<KsqlPrincipal> userPrincipal) {
        if (this.defaultConnectAuthHeader == null) {
            this.defaultConnectAuthHeader = this.buildDefaultAuthHeader();
        }
        Map configWithPrefixOverrides = this.ksqlConfig.valuesWithPrefixOverride("ksql.connect.");
        return new DefaultConnectClient(this.ksqlConfig.getString("ksql.connect.url"), this.buildAuthHeader(ksqlAuthHeader, incomingRequestHeaders), this.requestHeadersExtension.map(extension -> extension.getHeaders(userPrincipal)).orElse(Collections.emptyMap()), Optional.ofNullable(DefaultConnectClientFactory.newSslContext(configWithPrefixOverrides)), DefaultConnectClientFactory.shouldVerifySslHostname(configWithPrefixOverrides), this.ksqlConfig.getLong("ksql.connect.request.timeout.ms"));
    }

    @Override
    public synchronized void close() {
        if (this.credentialsFileWatcher != null) {
            this.credentialsFileWatcher.shutdown();
        }
    }

    private Optional<String> buildDefaultAuthHeader() {
        if (this.isCustomBasicAuthConfigured()) {
            String credentialsFile = this.ksqlConfig.getString("ksql.connect.basic.auth.credentials.file");
            if (this.ksqlConfig.getBoolean("ksql.connect.basic.auth.credentials.reload").booleanValue()) {
                this.startBasicAuthFileWatcher(credentialsFile);
            }
            return DefaultConnectClientFactory.buildBasicAuthHeader(credentialsFile);
        }
        return Optional.empty();
    }

    private Optional<String> buildAuthHeader(Optional<String> ksqlAuthHeader, List<Map.Entry<String, String>> incomingRequestHeaders) {
        ConnectRequestHeadersExtension extension;
        if (this.requestHeadersExtension.isPresent() && (extension = this.requestHeadersExtension.get()).shouldUseCustomAuthHeader()) {
            return extension.getAuthHeader(incomingRequestHeaders);
        }
        if (this.isCustomBasicAuthConfigured()) {
            return this.defaultConnectAuthHeader;
        }
        return ksqlAuthHeader;
    }

    private void startBasicAuthFileWatcher(String filePath) {
        try {
            this.credentialsFileWatcher = new FileWatcher(Paths.get(filePath, new String[0]), () -> {
                this.defaultConnectAuthHeader = DefaultConnectClientFactory.buildBasicAuthHeader(filePath);
            });
            this.credentialsFileWatcher.start();
            log.info("Enabled automatic connector credentials reload for location: " + filePath);
        }
        catch (IOException e) {
            log.error("Failed to enable automatic connector credentials reload", (Throwable)e);
        }
    }

    private boolean isCustomBasicAuthConfigured() {
        return this.ksqlConfig.getString("ksql.connect.basic.auth.credentials.source").equalsIgnoreCase("FILE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> buildBasicAuthHeader(String credentialsPath) {
        if (credentialsPath == null || credentialsPath.isEmpty()) {
            throw new ConfigException(String.format("'%s' cannot be empty if '%s' is set to '%s'", "ksql.connect.basic.auth.credentials.file", "ksql.connect.basic.auth.credentials.source", "FILE"));
        }
        Properties credentials = new Properties();
        try (FileInputStream inputStream = new FileInputStream(credentialsPath);){
            credentials.load(inputStream);
            if (credentials.containsKey("username") && credentials.containsKey("password")) {
                String userInfo = credentials.getProperty("username") + ":" + credentials.getProperty("password");
                Optional<CallSite> optional = Optional.of("Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes(Charset.defaultCharset())));
                return optional;
            }
            log.error("Provided credentials file doesn't provide username and password");
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            log.error("Failed to load credentials file: " + e.getMessage());
            return Optional.empty();
        }
    }

    private static SSLContext newSslContext(Map<String, Object> config) {
        DefaultSslEngineFactory sslFactory = new DefaultSslEngineFactory();
        sslFactory.configure(config);
        return sslFactory.sslContext();
    }

    @VisibleForTesting
    static boolean shouldVerifySslHostname(Map<String, Object> config) {
        Object endpointIdentificationAlgoConfig = config.get("ssl.endpoint.identification.algorithm");
        if (endpointIdentificationAlgoConfig == null) {
            return false;
        }
        String endpointIdentificationAlgo = endpointIdentificationAlgoConfig.toString();
        if (endpointIdentificationAlgo.isEmpty() || endpointIdentificationAlgo.equalsIgnoreCase("none")) {
            return false;
        }
        if (endpointIdentificationAlgo.equalsIgnoreCase("https")) {
            return true;
        }
        throw new ConfigException("Endpoint identification algorithm not supported: " + endpointIdentificationAlgo);
    }
}

