/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import io.confluent.ksql.exception.KafkaResponseGetFailedException;
import io.confluent.ksql.exception.KsqlGroupAuthorizationException;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import io.confluent.ksql.util.ExecutorUtil;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaConsumerGroupClientImpl
implements KafkaConsumerGroupClient {
    private final Supplier<Admin> adminClient;
    private static final Logger log = LogManager.getLogger(KafkaConsumerGroupClientImpl.class);

    public KafkaConsumerGroupClientImpl(Supplier<Admin> adminClient) {
        this.adminClient = adminClient;
    }

    public List<String> listGroups() {
        try {
            return ExecutorUtil.executeWithRetries(() -> (Collection)this.adminClient.get().listConsumerGroups().all().get(), ExecutorUtil.RetryBehaviour.ON_RETRYABLE).stream().map(ConsumerGroupListing::groupId).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new KafkaResponseGetFailedException("Failed to retrieve Kafka consumer groups", (Throwable)e);
        }
    }

    public KafkaConsumerGroupClient.ConsumerGroupSummary describeConsumerGroup(String group) {
        try {
            Map groupDescriptions = ExecutorUtil.executeWithRetries(() -> (Map)this.adminClient.get().describeConsumerGroups(Collections.singleton(group)).all().get(), ExecutorUtil.RetryBehaviour.ON_RETRYABLE);
            Set results = groupDescriptions.values().stream().flatMap(g -> g.members().stream().map(member -> {
                KafkaConsumerGroupClient.ConsumerSummary summary = new KafkaConsumerGroupClient.ConsumerSummary(member.consumerId());
                summary.addPartitions(member.assignment().topicPartitions());
                return summary;
            })).collect(Collectors.toSet());
            return new KafkaConsumerGroupClient.ConsumerGroupSummary(results);
        }
        catch (GroupAuthorizationException e) {
            throw new KsqlGroupAuthorizationException(AclOperation.DESCRIBE, group);
        }
        catch (GroupIdNotFoundException e) {
            log.debug("Consumer group '{}' not found, treating as empty. Reason: {}", (Object)group, (Object)e);
            return new KafkaConsumerGroupClient.ConsumerGroupSummary(Collections.emptySet());
        }
        catch (Exception e) {
            throw new KafkaResponseGetFailedException("Failed to describe Kafka consumer groups: " + group, (Throwable)e);
        }
    }

    public Map<TopicPartition, OffsetAndMetadata> listConsumerGroupOffsets(String group) {
        try {
            return ExecutorUtil.executeWithRetries(() -> (Map)this.adminClient.get().listConsumerGroupOffsets(group).partitionsToOffsetAndMetadata().get(), ExecutorUtil.RetryBehaviour.ON_RETRYABLE);
        }
        catch (GroupAuthorizationException e) {
            throw new KsqlGroupAuthorizationException(AclOperation.DESCRIBE, group);
        }
        catch (Exception e) {
            throw new KafkaResponseGetFailedException("Failed to list Kafka consumer groups offsets", (Throwable)e);
        }
    }

    public void deleteConsumerGroups(Set<String> groups) {
        try {
            ExecutorUtil.executeWithRetries(() -> (Void)this.adminClient.get().deleteConsumerGroups((Collection)groups).all().get(), e -> e instanceof RetriableException || e instanceof GroupNotEmptyException, retry -> Duration.of(3L * (long)retry.intValue(), ChronoUnit.SECONDS), 10);
        }
        catch (Exception e2) {
            throw new KafkaResponseGetFailedException("Failed to delete consumer groups: " + String.valueOf(groups), (Throwable)e2);
        }
    }
}

