/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;

final class SandboxedSchemaRegistryClient {
    static SchemaRegistryClient createProxy(SchemaRegistryClient delegate) {
        Objects.requireNonNull(delegate, "delegate");
        return new SandboxSchemaRegistryCache(delegate);
    }

    private SandboxedSchemaRegistryClient() {
    }

    static final class SandboxSchemaRegistryCache
    implements SchemaRegistryClient {
        private final MockSchemaRegistryClient sandboxCacheClient = new MockSchemaRegistryClient();
        private final SchemaRegistryClient srClient;

        private SandboxSchemaRegistryCache(SchemaRegistryClient delegate) {
            this.srClient = delegate;
        }

        public Ticker ticker() {
            throw new UnsupportedOperationException();
        }

        public String tenant() {
            throw new UnsupportedOperationException();
        }

        public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
            return this.sandboxCacheClient.parseSchema(schemaType, schemaString, references);
        }

        public RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
            return this.sandboxCacheClient.registerWithResponse(subject, schema, normalize);
        }

        public RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize, boolean propagateSchemaTags) throws RestClientException {
            return this.sandboxCacheClient.registerWithResponse(subject, schema, normalize, propagateSchemaTags);
        }

        public int register(String subject, ParsedSchema parsedSchema) throws RestClientException, IOException {
            return this.sandboxCacheClient.register(subject, parsedSchema);
        }

        public int register(String subject, ParsedSchema schema, boolean normalize) throws RestClientException, IOException {
            return this.sandboxCacheClient.register(subject, schema, normalize);
        }

        public int register(String subject, ParsedSchema parsedSchema, int version, int id) {
            return -1;
        }

        @Deprecated
        public Schema getById(int id) {
            throw new UnsupportedOperationException();
        }

        public ParsedSchema getSchemaById(int id) throws RestClientException, IOException {
            try {
                return this.srClient.getSchemaById(id);
            }
            catch (RestClientException e) {
                if (e.getStatus() == 404) {
                    return this.sandboxCacheClient.getSchemaById(id);
                }
                throw e;
            }
        }

        @Deprecated
        public Schema getBySubjectAndId(String subject, int id) {
            throw new UnsupportedOperationException();
        }

        public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws RestClientException, IOException {
            try {
                return this.srClient.getSchemaBySubjectAndId(subject, id);
            }
            catch (RestClientException e) {
                if (e.getStatus() == 404) {
                    return this.sandboxCacheClient.getSchemaBySubjectAndId(subject, id);
                }
                throw e;
            }
        }

        public Collection<String> getAllSubjectsById(int id) {
            throw new UnsupportedOperationException();
        }

        public SchemaMetadata getLatestSchemaMetadata(String subject) throws RestClientException, IOException {
            try {
                return this.srClient.getLatestSchemaMetadata(subject);
            }
            catch (RestClientException e) {
                if (e.getStatus() == 404) {
                    return this.sandboxCacheClient.getLatestSchemaMetadata(subject);
                }
                throw e;
            }
        }

        public SchemaMetadata getSchemaMetadata(String subject, int version) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public int getVersion(String subject, Schema parsedSchema) throws RestClientException, IOException {
            throw new UnsupportedOperationException();
        }

        public int getVersion(String subject, ParsedSchema parsedSchema) throws RestClientException, IOException {
            try {
                return this.srClient.getVersion(subject, parsedSchema);
            }
            catch (RestClientException e) {
                if (e.getStatus() == 404) {
                    return this.sandboxCacheClient.getVersion(subject, parsedSchema);
                }
                throw e;
            }
        }

        public List<Integer> getAllVersions(String subject) {
            throw new UnsupportedOperationException();
        }

        public boolean testCompatibility(String subject, ParsedSchema parsedSchema) throws RestClientException, IOException {
            return this.srClient.testCompatibility(subject, parsedSchema) && this.sandboxCacheClient.testCompatibility(subject, parsedSchema);
        }

        public String updateCompatibility(String subject, String compatibility) {
            throw new UnsupportedOperationException();
        }

        public String getCompatibility(String subject) {
            throw new UnsupportedOperationException();
        }

        public String setMode(String mode) {
            throw new UnsupportedOperationException();
        }

        public String setMode(String mode, String subject) {
            throw new UnsupportedOperationException();
        }

        public String getMode() {
            throw new UnsupportedOperationException();
        }

        public String getMode(String subject) {
            throw new UnsupportedOperationException();
        }

        public List<Integer> deleteSubject(String subject) throws IOException, RestClientException {
            return null;
        }

        public List<Integer> deleteSubject(String subject, boolean isPermanent) {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getAllSubjects() throws RestClientException, IOException {
            HashSet allSubjects = new HashSet(this.srClient.getAllSubjects());
            allSubjects.addAll(this.sandboxCacheClient.getAllSubjects());
            return ImmutableSet.copyOf(allSubjects);
        }

        public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
            return this.getId(subject, schema);
        }

        public int getId(String subject, ParsedSchema parsedSchema) throws RestClientException, IOException {
            try {
                return this.srClient.getId(subject, parsedSchema);
            }
            catch (RestClientException e) {
                if (e.getStatus() == 404) {
                    return this.sandboxCacheClient.getId(subject, parsedSchema);
                }
                throw e;
            }
        }

        public RegisterSchemaResponse getIdWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
            try {
                return this.srClient.getIdWithResponse(subject, schema, normalize);
            }
            catch (RestClientException e) {
                if (e.getStatus() == 404) {
                    return this.sandboxCacheClient.getIdWithResponse(subject, schema, normalize);
                }
                throw e;
            }
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }
    }
}

