/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.execution.streams.StepSchemaResolver;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.InternalFormats;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.structured.SchemaKTable;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SchemaKGroupedStream {
    final ExecutionStep<KGroupedStreamHolder> sourceStep;
    final LogicalSchema schema;
    final KeyFormat keyFormat;
    final KsqlConfig ksqlConfig;
    final FunctionRegistry functionRegistry;

    SchemaKGroupedStream(ExecutionStep<KGroupedStreamHolder> sourceStep, LogicalSchema schema, KeyFormat keyFormat, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        this.sourceStep = sourceStep;
        this.schema = Objects.requireNonNull(schema, "schema");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.functionRegistry = functionRegistry;
    }

    public ExecutionStep<KGroupedStreamHolder> getSourceStep() {
        return this.sourceStep;
    }

    public SchemaKTable<?> aggregate(List<ColumnName> nonAggregateColumns, List<FunctionCall> aggregations, Optional<WindowExpression> windowExpression, FormatInfo valueFormat, QueryContext.Stacker contextStacker) {
        StreamWindowedAggregate step;
        KeyFormat keyFormat;
        if (windowExpression.isPresent()) {
            keyFormat = this.getKeyFormat(windowExpression.get());
            step = ExecutionStepFactory.streamWindowedAggregate((QueryContext.Stacker)contextStacker, this.sourceStep, (Formats)InternalFormats.of(keyFormat, valueFormat), nonAggregateColumns, aggregations, (KsqlWindowExpression)windowExpression.get().getKsqlWindowExpression());
        } else {
            keyFormat = SerdeFeaturesFactory.sanitizeKeyFormat(this.keyFormat, this.toSqlTypes(this.schema.key()), false);
            step = ExecutionStepFactory.streamAggregate((QueryContext.Stacker)contextStacker, this.sourceStep, (Formats)InternalFormats.of(keyFormat, valueFormat), nonAggregateColumns, aggregations);
        }
        return new SchemaKTable(step, this.resolveSchema((ExecutionStep<?>)step), keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    private KeyFormat getKeyFormat(WindowExpression windowExpression) {
        return SerdeFeaturesFactory.sanitizeKeyFormat(KeyFormat.windowed((FormatInfo)this.keyFormat.getFormatInfo(), (SerdeFeatures)this.keyFormat.getFeatures(), (WindowInfo)windowExpression.getKsqlWindowExpression().getWindowInfo()), this.toSqlTypes(this.schema.key()), false);
    }

    protected List<SqlType> toSqlTypes(List<Column> columns) {
        return columns.stream().map(Column::type).collect(Collectors.toList());
    }

    LogicalSchema resolveSchema(ExecutionStep<?> step) {
        return new StepSchemaResolver(this.ksqlConfig, this.functionRegistry).resolve(step, this.schema);
    }
}

