/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.function.TableAggregationFunction;
import io.confluent.ksql.execution.function.UdafUtil;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.InternalFormats;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.structured.SchemaKGroupedStream;
import io.confluent.ksql.structured.SchemaKTable;
import io.confluent.ksql.util.GrammaticalJoiner;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SchemaKGroupedTable
extends SchemaKGroupedStream {
    private final ExecutionStep<KGroupedTableHolder> sourceTableStep;

    SchemaKGroupedTable(ExecutionStep<KGroupedTableHolder> sourceTableStep, LogicalSchema schema, KeyFormat keyFormat, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        super(null, schema, keyFormat, ksqlConfig, functionRegistry);
        this.sourceTableStep = Objects.requireNonNull(sourceTableStep, "sourceTableStep");
    }

    public ExecutionStep<KGroupedTableHolder> getSourceTableStep() {
        return this.sourceTableStep;
    }

    public SchemaKTable<GenericKey> aggregate(List<ColumnName> nonAggregateColumns, List<FunctionCall> aggregations, Optional<WindowExpression> windowExpression, FormatInfo valueFormat, QueryContext.Stacker contextStacker) {
        if (windowExpression.isPresent()) {
            throw new KsqlException("Windowing not supported for table aggregations.");
        }
        List unsupportedFunctionNames = aggregations.stream().map(call -> UdafUtil.resolveAggregateFunction((FunctionRegistry)this.functionRegistry, (FunctionCall)call, (LogicalSchema)this.schema, (KsqlConfig)this.ksqlConfig)).filter(function -> !(function instanceof TableAggregationFunction)).map(FunctionSignature::name).map(Name::text).distinct().collect(Collectors.toList());
        if (!unsupportedFunctionNames.isEmpty()) {
            String postfix = unsupportedFunctionNames.size() == 1 ? "" : "s";
            throw new KsqlException("The aggregation function" + postfix + " " + GrammaticalJoiner.and().join(unsupportedFunctionNames) + " cannot be applied to a table source, only to a stream source.");
        }
        TableAggregate step = ExecutionStepFactory.tableAggregate((QueryContext.Stacker)contextStacker, this.sourceTableStep, (Formats)InternalFormats.of(this.keyFormat, valueFormat), nonAggregateColumns, aggregations);
        return new SchemaKTable<GenericKey>((ExecutionStep<KTableHolder<GenericKey>>)step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }
}

