/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.ksql.engine.rewrite.StatementRewriteForMagicPseudoTimestamp;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.execution.streams.StepSchemaResolver;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.tree.WithinExpression;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.InternalFormats;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.structured.SchemaKGroupedStream;
import io.confluent.ksql.structured.SchemaKTable;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Repartitioning;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.streams.kstream.JoinWindows;

public class SchemaKStream<K> {
    final KeyFormat keyFormat;
    final KsqlConfig ksqlConfig;
    final FunctionRegistry functionRegistry;
    final LogicalSchema schema;
    private final ExecutionStep<KStreamHolder<K>> sourceStep;
    private final ExpressionTypeManager typeManager;

    SchemaKStream(ExecutionStep<KStreamHolder<K>> sourceStep, LogicalSchema schema, KeyFormat keyFormat, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.sourceStep = sourceStep;
        this.schema = Objects.requireNonNull(schema, "schema");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.typeManager = new ExpressionTypeManager(schema, functionRegistry);
    }

    public SchemaKStream<K> into(KsqlTopic topic, QueryContext.Stacker contextStacker, Optional<TimestampColumn> timestampColumn) {
        if (!this.keyFormat.getWindowInfo().equals(topic.getKeyFormat().getWindowInfo())) {
            throw new IllegalArgumentException("Into can't change windowing");
        }
        StreamSink step = ExecutionStepFactory.streamSink((QueryContext.Stacker)contextStacker, (Formats)Formats.from((KsqlTopic)topic), this.sourceStep, (String)topic.getKafkaTopicName(), timestampColumn);
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    public SchemaKStream<K> filter(Expression filterExpression, QueryContext.Stacker contextStacker) {
        StreamFilter step = ExecutionStepFactory.streamFilter((QueryContext.Stacker)contextStacker, this.sourceStep, (Expression)SchemaKStream.rewriteTimeComparisonForFilter(filterExpression));
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    static Expression rewriteTimeComparisonForFilter(Expression expression) {
        return new StatementRewriteForMagicPseudoTimestamp().rewrite(expression);
    }

    public SchemaKStream<K> select(List<ColumnName> keyColumnNames, List<SelectExpression> selectExpressions, QueryContext.Stacker contextStacker, PlanBuildContext buildContext, FormatInfo valueFormat) {
        StreamSelect step = ExecutionStepFactory.streamSelect((QueryContext.Stacker)contextStacker, this.sourceStep, keyColumnNames, Optional.empty(), selectExpressions);
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    public SchemaKStream<K> leftJoin(SchemaKTable<K> schemaKTable, ColumnName keyColName, FormatInfo leftValueFormat, QueryContext.Stacker contextStacker) {
        return this.join(schemaKTable, keyColName, leftValueFormat, contextStacker, JoinType.LEFT);
    }

    public SchemaKStream<K> leftJoin(SchemaKStream<K> otherSchemaKStream, ColumnName keyColName, WithinExpression withinExpression, FormatInfo leftFormat, FormatInfo rightFormat, QueryContext.Stacker contextStacker) {
        return this.join(otherSchemaKStream, keyColName, withinExpression, leftFormat, rightFormat, contextStacker, JoinType.LEFT);
    }

    public SchemaKStream<K> rightJoin(SchemaKStream<K> otherSchemaKStream, ColumnName keyColName, WithinExpression withinExpression, FormatInfo leftFormat, FormatInfo rightFormat, QueryContext.Stacker contextStacker) {
        return this.join(otherSchemaKStream, keyColName, withinExpression, leftFormat, rightFormat, contextStacker, JoinType.RIGHT);
    }

    public SchemaKStream<K> innerJoin(SchemaKTable<K> schemaKTable, ColumnName keyColName, FormatInfo leftValueFormat, QueryContext.Stacker contextStacker) {
        return this.join(schemaKTable, keyColName, leftValueFormat, contextStacker, JoinType.INNER);
    }

    public SchemaKStream<K> innerJoin(SchemaKStream<K> otherSchemaKStream, ColumnName keyColName, WithinExpression withinExpression, FormatInfo leftFormat, FormatInfo rightFormat, QueryContext.Stacker contextStacker) {
        return this.join(otherSchemaKStream, keyColName, withinExpression, leftFormat, rightFormat, contextStacker, JoinType.INNER);
    }

    public SchemaKStream<K> outerJoin(SchemaKStream<K> otherSchemaKStream, ColumnName keyColName, WithinExpression withinExpression, FormatInfo leftFormat, FormatInfo rightFormat, QueryContext.Stacker contextStacker) {
        return this.join(otherSchemaKStream, keyColName, withinExpression, leftFormat, rightFormat, contextStacker, JoinType.OUTER);
    }

    private SchemaKStream<K> join(SchemaKStream<K> otherSchemaKStream, ColumnName keyColName, WithinExpression withinExpression, FormatInfo leftFormat, FormatInfo rightFormat, QueryContext.Stacker contextStacker, JoinType joinType) {
        this.throwOnJoinKeyFormatsMismatch(otherSchemaKStream);
        StreamStreamJoin step = ExecutionStepFactory.streamStreamJoin((QueryContext.Stacker)contextStacker, (JoinType)joinType, (ColumnName)keyColName, (Formats)InternalFormats.of(this.keyFormat, leftFormat), (Formats)InternalFormats.of(this.keyFormat, rightFormat), this.sourceStep, otherSchemaKStream.sourceStep, (JoinWindows)withinExpression.joinWindow(), (Optional)withinExpression.getGrace());
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step, otherSchemaKStream), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    private SchemaKStream<K> join(SchemaKTable<K> schemaKTable, ColumnName keyColName, FormatInfo leftValueFormat, QueryContext.Stacker contextStacker, JoinType joinType) {
        this.throwOnJoinKeyFormatsMismatch(schemaKTable);
        StreamTableJoin step = ExecutionStepFactory.streamTableJoin((QueryContext.Stacker)contextStacker, (JoinType)joinType, (ColumnName)keyColName, (Formats)InternalFormats.of(this.keyFormat, leftValueFormat), this.sourceStep, schemaKTable.getSourceTableStep());
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step, (SchemaKStream<?>)schemaKTable), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    public SchemaKStream<K> selectKey(FormatInfo valueFormat, List<Expression> keyExpression, Optional<KeyFormat> forceInternalKeyFormat, QueryContext.Stacker contextStacker, boolean forceRepartition) {
        boolean keyFormatChange = forceInternalKeyFormat.isPresent() && !forceInternalKeyFormat.get().equals((Object)this.keyFormat);
        boolean repartitionNeeded = this.repartitionNeeded(keyExpression);
        if (!(keyFormatChange || forceRepartition || repartitionNeeded)) {
            return this;
        }
        if ((repartitionNeeded || !forceRepartition) && this.keyFormat.isWindowed()) {
            throw new KsqlException("Implicit repartitioning of windowed sources is not supported. See https://github.com/confluentinc/ksql/issues/4385.");
        }
        StreamSelectKey step = ExecutionStepFactory.streamSelectKey((QueryContext.Stacker)contextStacker, this.sourceStep, keyExpression);
        KeyFormat newKeyFormat = forceInternalKeyFormat.orElse(this.keyFormat);
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step), SerdeFeaturesFactory.sanitizeKeyFormat(newKeyFormat, this.toSqlTypes(keyExpression), true), this.ksqlConfig, this.functionRegistry);
    }

    boolean repartitionNeeded(List<Expression> expressions) {
        return Repartitioning.repartitionNeeded(this.schema, expressions);
    }

    public SchemaKGroupedStream groupBy(FormatInfo valueFormat, List<Expression> groupByExpressions, QueryContext.Stacker contextStacker) {
        KeyFormat rekeyedFormat;
        if (!this.repartitionNeeded(groupByExpressions)) {
            return this.groupByKey(this.keyFormat, valueFormat, contextStacker);
        }
        if (this.keyFormat.getFormatInfo().getFormat().equals("NONE")) {
            FormatInfo defaultFormat = FormatInfo.of((String)this.ksqlConfig.getString("ksql.persistence.default.format.key"));
            rekeyedFormat = KeyFormat.nonWindowed((FormatInfo)defaultFormat, (SerdeFeatures)SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
        } else {
            rekeyedFormat = this.keyFormat;
        }
        KeyFormat sanitizedKeyFormat = SerdeFeaturesFactory.sanitizeKeyFormat(rekeyedFormat, this.toSqlTypes(groupByExpressions), true);
        StreamGroupBy source = ExecutionStepFactory.streamGroupBy((QueryContext.Stacker)contextStacker, this.sourceStep, (Formats)InternalFormats.of(sanitizedKeyFormat, valueFormat), groupByExpressions);
        return new SchemaKGroupedStream((ExecutionStep<KGroupedStreamHolder>)source, this.resolveSchema((ExecutionStep<?>)source), sanitizedKeyFormat, this.ksqlConfig, this.functionRegistry);
    }

    protected List<SqlType> toSqlTypes(List<Expression> expressions) {
        return expressions.stream().map(arg_0 -> ((ExpressionTypeManager)this.typeManager).getExpressionSqlType(arg_0)).collect(Collectors.toList());
    }

    private SchemaKGroupedStream groupByKey(KeyFormat rekeyedKeyFormat, FormatInfo valueFormat, QueryContext.Stacker contextStacker) {
        if (this.keyFormat.isWindowed()) {
            throw new UnsupportedOperationException("Group by on windowed should always require rekey");
        }
        StreamGroupByKey step = ExecutionStepFactory.streamGroupByKey((QueryContext.Stacker)contextStacker, this.sourceStep, (Formats)InternalFormats.of(rekeyedKeyFormat, valueFormat));
        return new SchemaKGroupedStream((ExecutionStep<KGroupedStreamHolder>)step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    public SchemaKStream<K> flatMap(List<FunctionCall> tableFunctions, QueryContext.Stacker contextStacker) {
        StreamFlatMap step = ExecutionStepFactory.streamFlatMap((QueryContext.Stacker)contextStacker, this.sourceStep, tableFunctions);
        return new SchemaKStream<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    public ExecutionStep<?> getSourceStep() {
        return this.sourceStep;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    LogicalSchema resolveSchema(ExecutionStep<?> step) {
        return new StepSchemaResolver(this.ksqlConfig, this.functionRegistry).resolve(step, this.schema);
    }

    LogicalSchema resolveSchema(ExecutionStep<?> step, SchemaKStream<?> right) {
        return new StepSchemaResolver(this.ksqlConfig, this.functionRegistry).resolve(step, this.schema, right.getSchema());
    }

    void throwOnJoinKeyFormatsMismatch(SchemaKStream<?> right) {
        boolean rightIsSession;
        SerdeFeatures rightFeats;
        FormatInfo rightFmt;
        FormatInfo leftFmt = this.keyFormat.getFormatInfo();
        if (!leftFmt.equals((Object)(rightFmt = right.keyFormat.getFormatInfo()))) {
            throw new IllegalArgumentException("Key format mismatch in join. left: " + String.valueOf(leftFmt) + ", right: " + String.valueOf(rightFmt));
        }
        SerdeFeatures leftFeats = this.keyFormat.getFeatures();
        if (!leftFeats.equals((Object)(rightFeats = right.keyFormat.getFeatures()))) {
            throw new IllegalArgumentException("Key format features mismatch in join. left: " + String.valueOf(leftFeats) + ", right: " + String.valueOf(rightFeats));
        }
        Optional<WindowType> leftWnd = this.keyFormat.getWindowInfo().map(WindowInfo::getType);
        Optional<WindowType> rightWnd = right.keyFormat.getWindowInfo().map(WindowInfo::getType);
        if (leftWnd.isPresent() != rightWnd.isPresent()) {
            throw new IllegalArgumentException("Key format windowing mismatch in join. left: " + String.valueOf(leftWnd) + ", right: " + String.valueOf(rightWnd));
        }
        boolean leftIsSession = leftWnd.map(type -> type == WindowType.SESSION).orElse(false);
        if (leftIsSession != (rightIsSession = rightWnd.map(type -> type == WindowType.SESSION).orElse(false).booleanValue())) {
            throw new IllegalArgumentException("Key format window type mismatch in join. left: " + (leftIsSession ? "Session Windowed" : "Non Session Windowed") + ", right: " + (rightIsSession ? "Session Windowed" : "Non Session Windowed"));
        }
    }

    public static enum Type {
        SOURCE,
        PROJECT,
        FILTER,
        AGGREGATE,
        SINK,
        REKEY,
        JOIN,
        LIMIT;

    }
}

