/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import com.google.common.collect.Iterables;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.InternalFormats;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.structured.SchemaKGroupedTable;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Optional;

public class SchemaKTable<K>
extends SchemaKStream<K> {
    private final ExecutionStep<KTableHolder<K>> sourceTableStep;

    public SchemaKTable(ExecutionStep<KTableHolder<K>> sourceTableStep, LogicalSchema schema, KeyFormat keyFormat, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        super(null, schema, keyFormat, ksqlConfig, functionRegistry);
        this.sourceTableStep = sourceTableStep;
    }

    @Override
    public SchemaKTable<K> into(KsqlTopic topic, QueryContext.Stacker contextStacker, Optional<TimestampColumn> timestampColumn) {
        if (!this.keyFormat.getWindowInfo().equals(topic.getKeyFormat().getWindowInfo())) {
            throw new IllegalArgumentException("Can't change windowing");
        }
        TableSink step = ExecutionStepFactory.tableSink((QueryContext.Stacker)contextStacker, this.sourceTableStep, (Formats)Formats.from((KsqlTopic)topic), (String)topic.getKafkaTopicName(), timestampColumn);
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    @Override
    public SchemaKTable<K> filter(Expression filterExpression, QueryContext.Stacker contextStacker) {
        TableFilter step = ExecutionStepFactory.tableFilter((QueryContext.Stacker)contextStacker, this.sourceTableStep, (Expression)SchemaKTable.rewriteTimeComparisonForFilter(filterExpression));
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    @Override
    public SchemaKTable<K> select(List<ColumnName> keyColumnNames, List<SelectExpression> selectExpressions, QueryContext.Stacker contextStacker, PlanBuildContext buildContext, FormatInfo valueFormat) {
        TableSelect step = ExecutionStepFactory.tableMapValues((QueryContext.Stacker)contextStacker, this.sourceTableStep, keyColumnNames, selectExpressions, (Formats)InternalFormats.of(this.keyFormat, valueFormat));
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    @Override
    public SchemaKTable<K> selectKey(FormatInfo valueFormat, List<Expression> keyExpression, Optional<KeyFormat> forceInternalKeyFormat, QueryContext.Stacker contextStacker, boolean forceRepartition) {
        boolean keyFormatChange;
        boolean repartitionNeeded = this.repartitionNeeded(keyExpression);
        boolean bl = keyFormatChange = forceInternalKeyFormat.isPresent() && !forceInternalKeyFormat.get().equals((Object)this.keyFormat);
        if (!(forceRepartition || keyFormatChange || repartitionNeeded)) {
            return this;
        }
        if (this.schema.key().size() > 1) {
            throw new UnsupportedOperationException("Cannot repartition a TABLE source. If this is a join, joins on tables with multiple columns is not yet supported.");
        }
        if (repartitionNeeded) {
            throw new UnsupportedOperationException("Cannot repartition a TABLE source. If this is a join, make sure that the criteria uses the TABLE's key column " + ((Column)Iterables.getOnlyElement((Iterable)this.schema.key())).name().text() + " instead of " + String.valueOf(keyExpression));
        }
        if (this.keyFormat.isWindowed()) {
            String errorMsg = "Implicit repartitioning of windowed sources is not supported. See https://github.com/confluentinc/ksql/issues/4385.";
            String additionalMsg = forceRepartition ? " As a result, ksqlDB does not support joins on windowed sources with Schema-Registry-enabled key formats (AVRO, JSON_SR, PROTOBUF) at this time. Please repartition your sources to use a different key format before performing the join." : "";
            throw new KsqlException("Implicit repartitioning of windowed sources is not supported. See https://github.com/confluentinc/ksql/issues/4385." + additionalMsg);
        }
        KeyFormat newKeyFormat = SerdeFeaturesFactory.sanitizeKeyFormat(forceInternalKeyFormat.orElse(this.keyFormat), this.toSqlTypes(keyExpression), false);
        TableSelectKey step = ExecutionStepFactory.tableSelectKey((QueryContext.Stacker)contextStacker, this.sourceTableStep, (Formats)InternalFormats.of(newKeyFormat, valueFormat), keyExpression);
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step), newKeyFormat, this.ksqlConfig, this.functionRegistry);
    }

    @Override
    public ExecutionStep<?> getSourceStep() {
        return this.sourceTableStep;
    }

    public ExecutionStep<KTableHolder<K>> getSourceTableStep() {
        return this.sourceTableStep;
    }

    @Override
    public SchemaKGroupedTable groupBy(FormatInfo valueFormat, List<Expression> groupByExpressions, QueryContext.Stacker contextStacker) {
        KeyFormat groupedKeyFormat = SerdeFeaturesFactory.sanitizeKeyFormat(KeyFormat.nonWindowed((FormatInfo)this.keyFormat.getFormatInfo(), (SerdeFeatures)this.keyFormat.getFeatures()), this.toSqlTypes(groupByExpressions), true);
        TableGroupBy step = ExecutionStepFactory.tableGroupBy((QueryContext.Stacker)contextStacker, this.sourceTableStep, (Formats)InternalFormats.of(groupedKeyFormat, valueFormat), groupByExpressions);
        return new SchemaKGroupedTable((ExecutionStep<KGroupedTableHolder>)step, this.resolveSchema((ExecutionStep<?>)step), groupedKeyFormat, this.ksqlConfig, this.functionRegistry);
    }

    public SchemaKTable<K> innerJoin(SchemaKTable<K> schemaKTable, ColumnName keyColName, QueryContext.Stacker contextStacker) {
        return this.join(schemaKTable, keyColName, contextStacker, JoinType.INNER);
    }

    public SchemaKTable<K> leftJoin(SchemaKTable<K> schemaKTable, ColumnName keyColName, QueryContext.Stacker contextStacker) {
        return this.join(schemaKTable, keyColName, contextStacker, JoinType.LEFT);
    }

    public SchemaKTable<K> rightJoin(SchemaKTable<K> schemaKTable, ColumnName keyColName, QueryContext.Stacker contextStacker) {
        return this.join(schemaKTable, keyColName, contextStacker, JoinType.RIGHT);
    }

    public SchemaKTable<K> outerJoin(SchemaKTable<K> schemaKTable, ColumnName keyColName, QueryContext.Stacker contextStacker) {
        return this.join(schemaKTable, keyColName, contextStacker, JoinType.OUTER);
    }

    public <KRightT> SchemaKTable<K> foreignKeyInnerJoin(SchemaKTable<KRightT> schemaKTable, Optional<ColumnName> leftJoinColumnName, Optional<Expression> leftJoinExpression, QueryContext.Stacker contextStacker, FormatInfo valueFormatInfo) {
        return this.foreignKeyJoin(schemaKTable, leftJoinColumnName, leftJoinExpression, contextStacker, valueFormatInfo, JoinType.INNER);
    }

    public <KRightT> SchemaKTable<K> foreignKeyLeftJoin(SchemaKTable<KRightT> schemaKTable, Optional<ColumnName> leftJoinColumnName, Optional<Expression> leftJoinExpression, QueryContext.Stacker contextStacker, FormatInfo valueFormatInfo) {
        return this.foreignKeyJoin(schemaKTable, leftJoinColumnName, leftJoinExpression, contextStacker, valueFormatInfo, JoinType.LEFT);
    }

    public SchemaKTable<K> suppress(RefinementInfo refinementInfo, FormatInfo valueFormat, QueryContext.Stacker contextStacker) {
        TableSuppress step = ExecutionStepFactory.tableSuppress((QueryContext.Stacker)contextStacker, this.sourceTableStep, (RefinementInfo)refinementInfo, (Formats)InternalFormats.of(this.keyFormat, valueFormat));
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    private SchemaKTable<K> join(SchemaKTable<K> schemaKTable, ColumnName keyColName, QueryContext.Stacker contextStacker, JoinType joinType) {
        this.throwOnJoinKeyFormatsMismatch(schemaKTable);
        TableTableJoin step = ExecutionStepFactory.tableTableJoin((QueryContext.Stacker)contextStacker, (JoinType)joinType, (ColumnName)keyColName, this.sourceTableStep, schemaKTable.getSourceTableStep());
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step, (SchemaKStream<?>)schemaKTable), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }

    private <KRightT> SchemaKTable<K> foreignKeyJoin(SchemaKTable<KRightT> schemaKTable, Optional<ColumnName> leftJoinColumnName, Optional<Expression> leftJoinExpression, QueryContext.Stacker contextStacker, FormatInfo valueFormatInfo, JoinType joinType) {
        ForeignKeyTableTableJoin step = ExecutionStepFactory.foreignKeyTableTableJoin((QueryContext.Stacker)contextStacker, (JoinType)joinType, leftJoinColumnName, (Formats)InternalFormats.of(this.keyFormat, valueFormatInfo), this.sourceTableStep, schemaKTable.getSourceTableStep(), leftJoinExpression);
        return new SchemaKTable<K>(step, this.resolveSchema((ExecutionStep<?>)step, (SchemaKStream<?>)schemaKTable), this.keyFormat, this.ksqlConfig, this.functionRegistry);
    }
}

