/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.topic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartitionInfo;

public final class TopicProperties {
    public static final short DEFAULT_REPLICAS = -1;
    private static final String INVALID_TOPIC_NAME = ":INVALID:";
    private static final int INVALID_PARTITIONS = -1;
    private static final long DEFAULT_RETENTION_IN_MS = 604800000L;
    private final String topicName;
    private final Integer partitions;
    private final Short replicas;
    private final Long retentionMs;

    @VisibleForTesting
    TopicProperties(String topicName, Integer partitions, Short replicas, Long retentionMs) {
        this.topicName = topicName;
        this.partitions = partitions;
        this.replicas = replicas;
        this.retentionMs = retentionMs;
    }

    public String toString() {
        return "TopicProperties{topicName='" + this.getTopicName() + "', partitions=" + this.getPartitions() + ", replicas=" + this.getReplicas() + ", retentionMs=" + this.getRetentionInMillis() + "}";
    }

    public String getTopicName() {
        return this.topicName == null ? INVALID_TOPIC_NAME : this.topicName;
    }

    public int getPartitions() {
        return this.partitions == null ? -1 : this.partitions;
    }

    public short getReplicas() {
        return this.replicas == null ? (short)-1 : this.replicas;
    }

    public long getRetentionInMillis() {
        return this.retentionMs == null ? 604800000L : this.retentionMs;
    }

    public static final class Builder {
        private String name;
        private TopicProperties fromWithClause = new TopicProperties(null, null, null, null);
        private final TopicProperties fromOverrides = new TopicProperties(null, null, null, null);
        private final TopicProperties fromKsqlConfig = new TopicProperties(null, null, null, null);
        private Supplier<TopicProperties> fromSource = () -> new TopicProperties(null, null, null, null);

        Builder withName(String name) {
            this.name = name;
            return this;
        }

        Builder withWithClause(Optional<String> name, Optional<Integer> partitionCount, Optional<Short> replicationFactor, Optional<Long> retentionMs) {
            this.fromWithClause = new TopicProperties(name.orElse(null), partitionCount.orElse(null), replicationFactor.orElse(null), retentionMs.orElse(null));
            return this;
        }

        Builder withSource(Supplier<TopicDescription> descriptionSupplier, Supplier<Map<String, String>> configsSupplier) {
            this.fromSource = Suppliers.memoize(() -> {
                TopicDescription description = (TopicDescription)descriptionSupplier.get();
                Integer partitions = description.partitions().size();
                Short replicas = (short)((TopicPartitionInfo)description.partitions().get(0)).replicas().size();
                Map configs = (Map)configsSupplier.get();
                Long retentionMs = Long.parseLong(String.valueOf(configs.getOrDefault("retention.ms", String.valueOf(604800000L))));
                return new TopicProperties(null, partitions, replicas, retentionMs);
            });
            return this;
        }

        public TopicProperties build() {
            String name = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.fromWithClause.topicName, this.name});
            Objects.requireNonNull(name, "Was not supplied with any valid source for topic name!");
            if (StringUtils.strip((String)name).isEmpty()) {
                throw new KsqlException("Must have non-empty topic name.");
            }
            Integer partitions = Stream.of(this.fromWithClause.partitions, this.fromOverrides.partitions, this.fromKsqlConfig.partitions).filter(Objects::nonNull).findFirst().orElseGet(() -> this.fromSource.get().partitions);
            if (partitions == null) {
                throw new KsqlException("Cannot determine partitions for creating topic " + name);
            }
            Short replicas = Stream.of(this.fromWithClause.replicas, this.fromOverrides.replicas, this.fromKsqlConfig.replicas).filter(Objects::nonNull).findFirst().orElseGet(() -> this.fromSource.get().replicas);
            Long retentionMs = Stream.of(this.fromWithClause.retentionMs, this.fromOverrides.retentionMs, this.fromKsqlConfig.retentionMs).filter(Objects::nonNull).findFirst().orElseGet(() -> this.fromSource.get().retentionMs);
            return new TopicProperties(name, partitions, replicas, retentionMs);
        }
    }
}

