/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;

public class InvalidColumnException
extends KsqlException {
    private final ColumnReferenceExp column;
    private final String prefix;

    public InvalidColumnException(ColumnReferenceExp column, String message) {
        this("", column, message);
    }

    public InvalidColumnException(String prefix, ColumnReferenceExp column, String message) {
        super(InvalidColumnException.buildMessage(prefix, column, message));
        this.column = Objects.requireNonNull(column, "column");
        this.prefix = Objects.requireNonNull(prefix, "prefix");
    }

    public ColumnReferenceExp getColumnExp() {
        return this.column;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private static String buildMessage(String prefix, ColumnReferenceExp column, String message) {
        return NodeLocation.asPrefix((Optional)column.getLocation()) + prefix + (prefix.isEmpty() ? "C" : " c") + "olumn '" + String.valueOf(column) + "' " + message;
    }
}

