/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Collection;
import java.util.Optional;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;

public interface PersistentQueryMetadata
extends QueryMetadata {
    public Optional<DataSource.DataSourceType> getDataSourceType();

    public Optional<KsqlTopic> getResultTopic();

    public Optional<SourceName> getSinkName();

    public QuerySchemas getQuerySchemas();

    public PhysicalSchema getPhysicalSchema();

    public ExecutionStep<?> getPhysicalPlan();

    public Optional<DataSource> getSink();

    public KsqlConstants.PersistentQueryType getPersistentQueryType();

    public ProcessingLogger getProcessingLogger();

    public Optional<Materialization> getMaterialization(QueryId var1, QueryContext.Stacker var2);

    public void stop();

    public void stop(boolean var1);

    public void register();

    public StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse uncaughtHandler(Throwable var1);

    public Optional<ScalablePushRegistry> getScalablePushRegistry();

    public Collection<String> getSourceTopicNames();

    public static final class QueryListenerWrapper
    implements QueryMetadata.Listener {
        private final QueryMetadata.Listener listener;
        private final Optional<ScalablePushRegistry> scalablePushRegistry;

        protected QueryListenerWrapper(QueryMetadata.Listener listener, Optional<ScalablePushRegistry> scalablePushRegistry) {
            this.listener = listener;
            this.scalablePushRegistry = scalablePushRegistry;
        }

        @Override
        public void onError(QueryMetadata queryMetadata, QueryError error) {
            this.listener.onError(queryMetadata, error);
            this.scalablePushRegistry.ifPresent(ScalablePushRegistry::onError);
        }

        @Override
        public void onStateChange(QueryMetadata query, KafkaStreams.State old, KafkaStreams.State newState) {
            this.listener.onStateChange(query, old, newState);
        }

        @Override
        public void onPause(QueryMetadata queryMetadata) {
            this.listener.onPause(queryMetadata);
        }

        @Override
        public void onResume(QueryMetadata queryMetadata) {
            this.listener.onResume(queryMetadata);
        }

        @Override
        public void onClose(QueryMetadata queryMetadata) {
            this.listener.onClose(queryMetadata);
            this.scalablePushRegistry.ifPresent(ScalablePushRegistry::cleanup);
        }
    }
}

