/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import org.agrona.AbstractMutableDirectBuffer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;

public class ExpandableDirectByteBuffer
extends AbstractMutableDirectBuffer {
    public static final int MAX_BUFFER_LENGTH = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 128;
    private ByteBuffer byteBuffer;

    public ExpandableDirectByteBuffer() {
        this(128);
    }

    public ExpandableDirectByteBuffer(int initialCapacity) {
        this.byteBuffer = ByteBuffer.allocateDirect(initialCapacity);
        this.addressOffset = BufferUtil.address(this.byteBuffer);
        this.capacity = initialCapacity;
    }

    @Override
    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] byteArray() {
        return null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public int wrapAdjustment() {
        return 0;
    }

    @Override
    public void checkLimit(int limit) {
        this.ensureCapacity(limit, 0);
    }

    public String toString() {
        return "ExpandableDirectByteBuffer{address=" + this.addressOffset + ", capacity=" + this.capacity + ", byteBuffer=" + this.byteBuffer + '}';
    }

    @Override
    protected final void ensureCapacity(int index, int length) {
        if (index < 0 || length < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + index + " length=" + length);
        }
        long resultingPosition = (long)index + (long)length;
        int currentCapacity = this.capacity;
        if (resultingPosition > (long)currentCapacity) {
            if (resultingPosition > 0x7FFFFFF7L) {
                throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " maxCapacity=" + 0x7FFFFFF7);
            }
            int newCapacity = ExpandableDirectByteBuffer.calculateExpansion(currentCapacity, resultingPosition);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            long newAddress = BufferUtil.address(newBuffer);
            this.getBytes(0, newBuffer, 0, currentCapacity);
            this.byteBuffer = newBuffer;
            this.addressOffset = newAddress;
            this.capacity = newCapacity;
        }
    }

    private static int calculateExpansion(int currentLength, long requiredLength) {
        long value = Math.max(currentLength, 2);
        while (value < requiredLength) {
            if ((value += value >> 1) <= 0x7FFFFFF7L) continue;
            value = 0x7FFFFFF7L;
        }
        return (int)value;
    }
}

