/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;
import org.agrona.collections.IntIntFunction;
import org.agrona.collections.IntIntPredicate;

public class Int2IntHashMap
implements Map<Integer, Integer> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private int[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Int2IntHashMap(int missingValue) {
        this(8, 0.65f, missingValue);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public Int2IntHashMap(Int2IntHashMap mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.missingValue = mapToCopy.missingValue;
        this.entries = (int[])mapToCopy.entries.clone();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    public int getOrDefault(int key, int defaultValue) {
        int value = this.get(key);
        return this.missingValue != value ? value : defaultValue;
    }

    public int get(int key) {
        int value;
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Int2IntHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public int put(int key, int value) {
        int oldValue;
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Int2IntHashMap.next(index, mask);
        }
        if (missingValue == oldValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    @Override
    public int putIfAbsent(int key, int value) {
        int oldValue;
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1])) {
            if (key == entries[index]) {
                return oldValue;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        ++this.size;
        entries[index] = key;
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int missingValue = this.missingValue;
        int[] oldEntries = this.entries;
        int length = oldEntries.length;
        this.capacity(newCapacity);
        int[] newEntries = this.entries;
        int mask = newEntries.length - 1;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = oldEntries[valueIndex];
            if (missingValue == value) continue;
            int key = oldEntries[valueIndex - 1];
            int newKeyIndex = Hashing.evenHash(key, mask);
            while (missingValue != newEntries[newKeyIndex + 1]) {
                newKeyIndex = Int2IntHashMap.next(newKeyIndex, mask);
            }
            newEntries[newKeyIndex] = key;
            newEntries[newKeyIndex + 1] = value;
        }
    }

    @Deprecated
    public void intForEach(IntIntConsumer consumer) {
        this.forEachInt(consumer);
    }

    public void forEachInt(IntIntConsumer consumer) {
        Objects.requireNonNull(consumer);
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int length = entries.length;
        int remaining = this.size;
        for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
            if (missingValue == entries[valueIndex]) continue;
            consumer.accept(entries[valueIndex - 1], entries[valueIndex]);
            --remaining;
        }
    }

    public boolean containsKey(int key) {
        return this.missingValue != this.get(key);
    }

    public boolean containsValue(int value) {
        boolean found = false;
        int missingValue = this.missingValue;
        if (missingValue != value) {
            int[] entries = this.entries;
            int length = entries.length;
            int remaining = this.size;
            for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
                int existingValue = entries[valueIndex];
                if (missingValue == existingValue) continue;
                if (existingValue == value) {
                    found = true;
                    break;
                }
                --remaining;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value;
        Objects.requireNonNull(mappingFunction);
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Int2IntHashMap.next(index, mask);
        }
        if (missingValue == value && missingValue != (value = mappingFunction.applyAsInt(key))) {
            entries[index] = key;
            entries[index + 1] = value;
            ++this.size;
            this.increaseCapacity();
        }
        return value;
    }

    public int computeIfPresent(int key, IntBinaryOperator remappingFunction) {
        int value;
        Objects.requireNonNull(remappingFunction);
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Int2IntHashMap.next(index, mask);
        }
        if (missingValue != value) {
            entries[index + 1] = value = remappingFunction.applyAsInt(key, value);
            if (value == missingValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return value;
    }

    public int compute(int key, IntBinaryOperator remappingFunction) {
        int oldValue;
        Objects.requireNonNull(remappingFunction);
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Int2IntHashMap.next(index, mask);
        }
        int newValue = remappingFunction.applyAsInt(key, oldValue);
        if (missingValue != newValue) {
            entries[index + 1] = newValue;
            if (oldValue == missingValue) {
                entries[index] = key;
                ++this.size;
                this.increaseCapacity();
            }
        } else if (missingValue != oldValue) {
            entries[index + 1] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    @Override
    public Integer get(Object key) {
        return this.valOrNull(this.get((Integer)key));
    }

    @Override
    public Integer put(Integer key, Integer value) {
        return this.valOrNull(this.put((int)key, (int)value));
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        this.forEachInt(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        for (Map.Entry<? extends Integer, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Int2IntHashMap map) {
        EntryIterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            it.findNext();
            this.put(it.getIntKey(), it.getIntValue());
        }
    }

    @Override
    public Integer putIfAbsent(Integer key, Integer value) {
        return this.valOrNull(this.putIfAbsent((int)key, (int)value));
    }

    @Override
    public Integer replace(Integer key, Integer value) {
        return this.valOrNull(this.replace((int)key, (int)value));
    }

    @Override
    public boolean replace(Integer key, Integer oldValue, Integer newValue) {
        return this.replace((int)key, (int)oldValue, (int)newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Integer, ? extends Integer> function) {
        this.replaceAllInt(function::apply);
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Integer remove(Object key) {
        return this.valOrNull(this.remove((Integer)key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Integer)value);
    }

    public int remove(int key) {
        int oldValue;
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    public boolean remove(int key, int value) {
        int oldValue;
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                if (value != oldValue) break;
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                return true;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return false;
    }

    public int merge(int key, int value, IntIntFunction remappingFunction) {
        int newValue;
        int oldValue;
        Objects.requireNonNull(remappingFunction);
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Int2IntHashMap.next(index, mask);
        }
        int n = newValue = missingValue == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (missingValue != newValue) {
            entries[index + 1] = newValue;
            if (oldValue == missingValue) {
                entries[index] = key;
                ++this.size;
                this.increaseCapacity();
            }
        } else {
            entries[index + 1] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    private void compactChain(int deleteKeyIndex) {
        int value;
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (missingValue != (value = entries[(keyIndex = Int2IntHashMap.next(keyIndex, mask)) + 1])) {
            int key = entries[keyIndex];
            int hash = Hashing.evenHash(key, mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = key;
            entries[deleteKeyIndex + 1] = value;
            entries[keyIndex + 1] = missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public int minValue() {
        int missingValue = this.missingValue;
        int min = 0 == this.size ? missingValue : Integer.MAX_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = entries[valueIndex];
            if (missingValue == value) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int missingValue = this.missingValue;
        int max = 0 == this.size ? missingValue : Integer.MIN_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = entries[valueIndex];
            if (missingValue == value) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getIntKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public int replace(int key, int value) {
        int oldValue;
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                entries[keyIndex + 1] = value;
                break;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        int value;
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                if (oldValue != value) break;
                entries[keyIndex + 1] = newValue;
                return true;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return false;
    }

    public void replaceAllInt(IntIntFunction function) {
        Objects.requireNonNull(function);
        int missingValue = this.missingValue;
        int[] entries = this.entries;
        int length = entries.length;
        int remaining = this.size;
        for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
            int existingValue = entries[valueIndex];
            if (missingValue == existingValue) continue;
            int newValue = function.apply(entries[valueIndex - 1], existingValue);
            if (missingValue == newValue) {
                throw new IllegalArgumentException("cannot replace with a missingValue");
            }
            entries[valueIndex] = newValue;
            --remaining;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Integer valOrNull(int value) {
        return this.missingValue == value ? null : Integer.valueOf(value);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Integer>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Integer value = Int2IntHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        public boolean removeIfInt(IntIntPredicate filter) {
            boolean removed = false;
            EntryIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.findNext();
                if (!filter.test(iterator.getIntKey(), iterator.getIntValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Int2IntHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Int2IntHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int value) {
            return Int2IntHashMap.this.containsValue(value);
        }

        public boolean removeIfInt(IntPredicate filter) {
            boolean removed = false;
            ValueIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!filter.test(iterator.nextValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsKey(key);
        }

        public boolean removeIfInt(IntPredicate filter) {
            boolean removed = false;
            KeyIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!filter.test(iterator.nextValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Integer>>,
    Map.Entry<Integer, Integer> {
        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public int setValue(int value) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Int2IntHashMap.this.missingValue == value) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int keyPosition = this.keyPosition();
            int[] entries = Int2IntHashMap.this.entries;
            int prevValue = entries[keyPosition + 1];
            entries[keyPosition + 1] = value;
            return prevValue;
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            this.findNext();
            if (Int2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, Integer> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getIntValue());
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.getIntKey()) ^ Integer.hashCode(this.getIntValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public final class MapEntry
        implements Map.Entry<Integer, Integer> {
            private final int k;
            private final int v;

            public MapEntry(int k, int v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public Integer getValue() {
                return this.v;
            }

            @Override
            public Integer setValue(Integer value) {
                return Int2IntHashMap.this.put(this.k, (int)value);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ Integer.hashCode(EntryIterator.this.getIntValue());
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getValue() != null && e.getKey().equals(this.k) && e.getValue().equals(this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Int2IntHashMap.this.size;
            int missingValue = Int2IntHashMap.this.missingValue;
            int[] entries = Int2IntHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (missingValue != entries[capacity - 1]) {
                for (int i = 1; i < capacity; i += 2) {
                    if (missingValue != entries[i]) continue;
                    keyIndex = i - 1;
                    break;
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected final int keyPosition() {
            return this.positionCounter & Int2IntHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int[] entries = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries.length - 1;
            int stop = this.stopCounter;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= stop; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (missingValue == entries[index + 1]) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Int2IntHashMap)Int2IntHashMap.this).entries[position + 1] = Int2IntHashMap.this.missingValue;
            --Int2IntHashMap.this.size;
            Int2IntHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

