/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.collect.Maps;
import java.util.Map;

public class NamedConfigUtils {
    public static void parseNamedConfigs(Map<String, Map<String, Object>> namedConfigMap, Map<String, Object> configsToParse) {
        for (Map.Entry<String, Object> entry : configsToParse.entrySet()) {
            String key = entry.getKey();
            int nameLength = key.indexOf(".");
            if (nameLength <= 0) continue;
            String name = key.substring(0, nameLength);
            String property = key.substring(nameLength + 1);
            namedConfigMap.computeIfAbsent(name, k -> Maps.newHashMap()).put(property, entry.getValue());
        }
    }
}

