/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.config.ConfigException;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncHttpsJwks
extends HttpsJwks
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpsJwks.class);
    private final ScheduledExecutorService scheduler;
    private final AtomicReference<List<JsonWebKey>> jwks = new AtomicReference();
    private static final Random RANDOM = new Random();
    private static final int DEFAULT_MIN_ERROR_BACKOFF_INTERVAL_MS = 100;
    private static final int DEFAULT_MAX_ERROR_BACKOFF_INTERVAL_MS = 500;
    public static final long DEFAULT_REFRESH_INTERVAL_MS = 3600000L;

    public AsyncHttpsJwks(URI location) {
        this(location.toString());
    }

    public AsyncHttpsJwks(String location) {
        this(location, false, 3600000L);
    }

    public AsyncHttpsJwks(String location, boolean unsafeAllowed, long refreshIntervalMs) {
        this(null, location, unsafeAllowed, refreshIntervalMs);
    }

    public AsyncHttpsJwks(SimpleGet httpGet, String location, boolean unsafeAllowed, long refreshIntervalMs) {
        super(location);
        if (httpGet != null) {
            this.setSimpleHttpGet(httpGet);
        }
        if (refreshIntervalMs <= 0L) {
            refreshIntervalMs = 3600000L;
        }
        this.validateJwksEndpoint(location, unsafeAllowed);
        this.jwks.set(Collections.emptyList());
        this.setDefaultCacheDuration(refreshIntervalMs);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(this::refreshTask, 0L, refreshIntervalMs, TimeUnit.MILLISECONDS);
        log.info("Validation key refresh thread started with a refresh interval of {} ms.", (Object)refreshIntervalMs);
    }

    private void validateJwksEndpoint(String location, boolean unsafeAllowed) {
        try {
            URL jwksUrl = new URL(location);
            if (!jwksUrl.getProtocol().equalsIgnoreCase("https") && !unsafeAllowed) {
                throw new ConfigException("Jwks endpoint must use HTTPS protocol.");
            }
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Malformed JWKs endpoint.", (Object)e);
        }
    }

    private void refreshTask() {
        try {
            super.refresh();
            this.jwks.set(super.getJsonWebKeys());
        }
        catch (IOException | JoseException e) {
            log.error(String.format("Failed to obtain jwks from %s: %s", this.getLocation(), e.getMessage()));
            this.scheduler.schedule(this::refreshTask, (long)this.retryBackoff(), TimeUnit.MILLISECONDS);
        }
    }

    public void refresh() {
        log.info("scheduling validation key refresh");
        this.scheduler.schedule(this::refreshTask, 0L, TimeUnit.MILLISECONDS);
    }

    void syncRefresh() {
        this.refreshTask();
    }

    private int retryBackoff() {
        return RANDOM.nextInt(400) + 100;
    }

    public List<JsonWebKey> getJsonWebKeys() {
        return this.jwks.get();
    }

    public boolean isRunning() {
        return this.scheduler != null && !this.scheduler.isShutdown();
    }

    @Override
    public void close() {
        if (this.isRunning()) {
            log.info("Shutting scheduler down.");
            this.scheduler.shutdownNow();
        }
    }
}

