/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.security.util.JwtUtils;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnverifiedJwtBearerToken
implements OAuthBearerToken {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String value;
    private final JwtClaims jwtClaims;
    private final String principalName;
    private final long lifetimeMs;

    public UnverifiedJwtBearerToken(String value) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipAllDefaultValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        try {
            this.jwtClaims = jwtConsumer.processToClaims(value);
            this.value = value;
            this.principalName = this.jwtClaims.getSubject();
            this.lifetimeMs = this.jwtClaims.getExpirationTime().getValueInMillis();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new ConfigException("Failed to construct JwtBearerToken " + JwtUtils.errorMessage(e));
        }
    }

    public String value() {
        return this.value;
    }

    public Set<String> scope() {
        throw new UnsupportedOperationException("Parsing scope claim from unverified bearer token is not supported");
    }

    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    public String principalName() {
        return this.principalName;
    }

    public Long startTimeMs() {
        throw new UnsupportedOperationException("Parsing iat claim from unverified bearer token is not supported");
    }

    public <T> Optional<T> claim(String claim, Class<T> claimType) {
        try {
            return Optional.of(this.jwtClaims.getClaimValue(claim, claimType));
        }
        catch (MalformedClaimException e) {
            this.log.error("Failed to retrieve claim " + claim, (Throwable)e);
            return Optional.empty();
        }
    }
}

