/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.security.auth.client.rest.jackson.AclBindingFilterMapKeyDeserializer;
import io.confluent.security.auth.client.rest.jackson.AclBindingFilterMapKeySerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

public class DeleteAclsResult {
    @JsonSerialize(keyUsing=AclBindingFilterMapKeySerializer.class)
    @JsonDeserialize(keyUsing=AclBindingFilterMapKeyDeserializer.class)
    public final Map<AclBindingFilter, DeleteResult> resultMap;

    @JsonCreator
    public DeleteAclsResult(@JsonProperty(value="resultMap") Map<AclBindingFilter, DeleteResult> resultMap) {
        this.resultMap = resultMap;
    }

    public static DeleteResult success(Collection<AclBinding> deletedBindings) {
        return new DeleteResult(true, deletedBindings, "");
    }

    public static DeleteResult failure(String errorMessage) {
        return new DeleteResult(false, Collections.emptyList(), errorMessage);
    }

    public String toString() {
        return "DeleteAclsResult{resultMap=" + String.valueOf(this.resultMap) + "}";
    }

    public static class DeleteResult {
        public Boolean success;
        public Collection<AclBinding> aclBindings;
        public String errorMessage;

        @JsonCreator
        DeleteResult(@JsonProperty(value="success") Boolean success, @JsonProperty(value="aclBindings") Collection<AclBinding> aclBindings, @JsonProperty(value="errorMessage") String errorMessage) {
            this.success = success;
            this.aclBindings = aclBindings;
            this.errorMessage = errorMessage;
        }

        public String toString() {
            return "DeleteResult{success=" + this.success + ", aclBindings=" + String.valueOf(this.aclBindings) + ", errorMessage='" + this.errorMessage + "'}";
        }
    }
}

