/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka.image.publisher;

import io.confluent.k2.kafka.K2Node;
import io.confluent.k2.kafka.K2TopicMetadata;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableSet;

public record K2TopicsImage(ImmutableMap<Uuid, String> topicIdToName, ImmutableMap<String, Uuid> topicNameToId, ImmutableMap<String, K2TopicMetadata> topicNameToMetadata, ImmutableMap<Uuid, Map<TopicIdPartition, List<K2Node>>> assignments, ImmutableSet<K2TopicMetadata> deletingTopics) {
    public static final K2TopicsImage EMPTY = new K2TopicsImage((ImmutableMap<Uuid, String>)ImmutableMap.empty(), (ImmutableMap<String, Uuid>)ImmutableMap.empty(), (ImmutableMap<String, K2TopicMetadata>)ImmutableMap.empty(), (ImmutableMap<Uuid, Map<TopicIdPartition, List<K2Node>>>)ImmutableMap.empty(), (ImmutableSet<K2TopicMetadata>)ImmutableSet.empty());

    public K2TopicsImage {
        Objects.requireNonNull(topicIdToName);
        Objects.requireNonNull(topicNameToId);
        Objects.requireNonNull(topicNameToMetadata);
        Objects.requireNonNull(assignments);
        Objects.requireNonNull(deletingTopics);
    }

    public List<TopicPartition> partitionsDeletedRelativeTo(K2TopicsImage otherImage) {
        return otherImage.assignments.entrySet().stream().filter(entry -> {
            Uuid topicIdFromPrevImage = (Uuid)entry.getKey();
            return !this.topicIdToName.containsKey((Object)topicIdFromPrevImage);
        }).flatMap(deletedEntry -> ((Map)deletedEntry.getValue()).keySet().stream()).map(TopicIdPartition::topicPartition).toList();
    }

    public boolean assignmentsEqual(K2TopicsImage otherImage) {
        return this.assignments.equals(otherImage.assignments);
    }

    public Map<TopicIdPartition, List<K2Node>> assignmentsForTopic(Uuid topicId) {
        return (Map)this.assignments.get((Object)topicId);
    }
}

