/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.flowables;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.annotations.BackpressureKind;
import io.confluent.shaded.io.reactivex.annotations.BackpressureSupport;
import io.confluent.shaded.io.reactivex.annotations.CheckReturnValue;
import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.annotations.SchedulerSupport;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.functions.Consumer;
import io.confluent.shaded.io.reactivex.internal.functions.Functions;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableAutoConnect;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowablePublishAlt;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowablePublishClassic;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableRefCount;
import io.confluent.shaded.io.reactivex.internal.util.ConnectConsumer;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public abstract class ConnectableFlowable<T>
extends Flowable<T> {
    public abstract void connect(@NonNull Consumer<? super Disposable> var1);

    public final Disposable connect() {
        ConnectConsumer cc = new ConnectConsumer();
        this.connect(cc);
        return cc.disposable;
    }

    private ConnectableFlowable<T> onRefCount() {
        if (this instanceof FlowablePublishClassic) {
            FlowablePublishClassic fp = (FlowablePublishClassic)((Object)this);
            return RxJavaPlugins.onAssembly(new FlowablePublishAlt(fp.publishSource(), fp.publishBufferSize()));
        }
        return this;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public Flowable<T> refCount() {
        return RxJavaPlugins.onAssembly(new FlowableRefCount<T>(this.onRefCount()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(int subscriberCount) {
        return this.refCount(subscriberCount, 0L, TimeUnit.NANOSECONDS, Schedulers.trampoline());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.confluent.shaded.io.reactivex:computation")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(long timeout, TimeUnit unit) {
        return this.refCount(1, timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.refCount(1, timeout, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.confluent.shaded.io.reactivex:computation")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(int subscriberCount, long timeout, TimeUnit unit) {
        return this.refCount(subscriberCount, timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(int subscriberCount, long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive(subscriberCount, "subscriberCount");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableRefCount<T>(this.onRefCount(), subscriberCount, timeout, unit, scheduler));
    }

    @NonNull
    public Flowable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, Functions.emptyConsumer());
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers, @NonNull Consumer<? super Disposable> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableAutoConnect(this, numberOfSubscribers, connection));
    }
}

