/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.maybe;

import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.MaybeSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;

public final class MaybeOnErrorReturn<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> valueSupplier;

    public MaybeOnErrorReturn(MaybeSource<T> source, Function<? super Throwable, ? extends T> valueSupplier) {
        super(source);
        this.valueSupplier = valueSupplier;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new OnErrorReturnMaybeObserver<T>(observer, this.valueSupplier));
    }

    static final class OnErrorReturnMaybeObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final Function<? super Throwable, ? extends T> valueSupplier;
        Disposable upstream;

        OnErrorReturnMaybeObserver(MaybeObserver<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            this.downstream = actual;
            this.valueSupplier = valueSupplier;
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            T v;
            try {
                v = ObjectHelper.requireNonNull(this.valueSupplier.apply(e), "The valueSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            this.downstream.onSuccess(v);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

