/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.subscribers;

import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.NotificationLite;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;

public final class BlockingSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = -4875965440900746268L;
    public static final Object TERMINATED = new Object();
    final Queue<Object> queue;

    public BlockingSubscriber(Queue<Object> queue) {
        this.queue = queue;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this, s)) {
            this.queue.offer(NotificationLite.subscription(this));
        }
    }

    @Override
    public void onNext(T t) {
        this.queue.offer(NotificationLite.next(t));
    }

    @Override
    public void onError(Throwable t) {
        this.queue.offer(NotificationLite.error(t));
    }

    @Override
    public void onComplete() {
        this.queue.offer(NotificationLite.complete());
    }

    @Override
    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    @Override
    public void cancel() {
        if (SubscriptionHelper.cancel(this)) {
            this.queue.offer(TERMINATED);
        }
    }

    public boolean isCancelled() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }
}

