/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.observers;

import io.confluent.shaded.io.reactivex.Notification;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.functions.Predicate;
import io.confluent.shaded.io.reactivex.internal.functions.Functions;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.util.ExceptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.VolatileSizeArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class BaseTestConsumer<T, U extends BaseTestConsumer<T, U>>
implements Disposable {
    protected final CountDownLatch done;
    protected final List<T> values = new VolatileSizeArrayList();
    protected final List<Throwable> errors = new VolatileSizeArrayList<Throwable>();
    protected long completions;
    protected Thread lastThread;
    protected boolean checkSubscriptionOnce;
    protected int initialFusionMode;
    protected int establishedFusionMode;
    protected CharSequence tag;
    protected boolean timeout;

    public BaseTestConsumer() {
        this.done = new CountDownLatch(1);
    }

    public final Thread lastThread() {
        return this.lastThread;
    }

    public final List<T> values() {
        return this.values;
    }

    public final List<Throwable> errors() {
        return this.errors;
    }

    public final long completions() {
        return this.completions;
    }

    public final boolean isTerminated() {
        return this.done.getCount() == 0L;
    }

    public final int valueCount() {
        return this.values.size();
    }

    public final int errorCount() {
        return this.errors.size();
    }

    protected final AssertionError fail(String message) {
        CharSequence tag;
        StringBuilder b = new StringBuilder(64 + message.length());
        b.append(message);
        b.append(" (").append("latch = ").append(this.done.getCount()).append(", ").append("values = ").append(this.values.size()).append(", ").append("errors = ").append(this.errors.size()).append(", ").append("completions = ").append(this.completions);
        if (this.timeout) {
            b.append(", timeout!");
        }
        if (this.isDisposed()) {
            b.append(", disposed!");
        }
        if ((tag = this.tag) != null) {
            b.append(", tag = ").append(tag);
        }
        b.append(')');
        AssertionError ae = new AssertionError((Object)b.toString());
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.errors.get(0));
            } else {
                CompositeException ce = new CompositeException(this.errors);
                ((Throwable)((Object)ae)).initCause(ce);
            }
        }
        return ae;
    }

    public final U await() throws InterruptedException {
        if (this.done.getCount() == 0L) {
            return (U)this;
        }
        this.done.await();
        return (U)this;
    }

    public final boolean await(long time, TimeUnit unit) throws InterruptedException {
        boolean d = this.done.getCount() == 0L || this.done.await(time, unit);
        this.timeout = !d;
        return d;
    }

    public final U assertComplete() {
        long c = this.completions;
        if (c == 0L) {
            throw this.fail("Not completed");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return (U)this;
    }

    public final U assertNotComplete() {
        long c = this.completions;
        if (c == 1L) {
            throw this.fail("Completed!");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return (U)this;
    }

    public final U assertNoErrors() {
        int s = this.errors.size();
        if (s != 0) {
            throw this.fail("Error(s) present: " + this.errors);
        }
        return (U)this;
    }

    public final U assertError(Throwable error) {
        return this.assertError(Functions.equalsWith(error));
    }

    public final U assertError(Class<? extends Throwable> errorClass) {
        return this.assertError(Functions.isInstanceOf(errorClass));
    }

    public final U assertError(Predicate<Throwable> errorPredicate) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e : this.errors) {
            try {
                if (!errorPredicate.test(e)) continue;
                found = true;
                break;
            }
            catch (Exception ex) {
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if (found) {
            if (s != 1) {
                throw this.fail("Error present but other errors as well");
            }
        } else {
            throw this.fail("Error not present");
        }
        return (U)this;
    }

    public final U assertValue(T value) {
        int s = this.values.size();
        if (s != 1) {
            throw this.fail("expected: " + BaseTestConsumer.valueAndClass(value) + " but was: " + this.values);
        }
        T v = this.values.get(0);
        if (!ObjectHelper.equals(value, v)) {
            throw this.fail("expected: " + BaseTestConsumer.valueAndClass(value) + " but was: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertNever(T value) {
        int s = this.values.size();
        for (int i = 0; i < s; ++i) {
            T v = this.values.get(i);
            if (!ObjectHelper.equals(v, value)) continue;
            throw this.fail("Value at position " + i + " is equal to " + BaseTestConsumer.valueAndClass(value) + "; Expected them to be different");
        }
        return (U)this;
    }

    public final U assertValue(Predicate<T> valuePredicate) {
        this.assertValueAt(0, valuePredicate);
        if (this.values.size() > 1) {
            throw this.fail("Value present but other values as well");
        }
        return (U)this;
    }

    public final U assertNever(Predicate<? super T> valuePredicate) {
        int s = this.values.size();
        for (int i = 0; i < s; ++i) {
            T v = this.values.get(i);
            try {
                if (!valuePredicate.test(v)) continue;
                throw this.fail("Value at position " + i + " matches predicate " + valuePredicate.toString() + ", which was not expected.");
            }
            catch (Exception ex) {
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        return (U)this;
    }

    public final U assertValueAt(int index, T value) {
        int s = this.values.size();
        if (s == 0) {
            throw this.fail("No values");
        }
        if (index >= s) {
            throw this.fail("Invalid index: " + index);
        }
        T v = this.values.get(index);
        if (!ObjectHelper.equals(value, v)) {
            throw this.fail("expected: " + BaseTestConsumer.valueAndClass(value) + " but was: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertValueAt(int index, Predicate<T> valuePredicate) {
        int s = this.values.size();
        if (s == 0) {
            throw this.fail("No values");
        }
        if (index >= this.values.size()) {
            throw this.fail("Invalid index: " + index);
        }
        boolean found = false;
        try {
            if (valuePredicate.test(this.values.get(index))) {
                found = true;
            }
        }
        catch (Exception ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (!found) {
            throw this.fail("Value not present");
        }
        return (U)this;
    }

    public static String valueAndClass(Object o) {
        if (o != null) {
            return o + " (class: " + o.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    public final U assertValueCount(int count) {
        int s = this.values.size();
        if (s != count) {
            throw this.fail("Value counts differ; expected: " + count + " but was: " + s);
        }
        return (U)this;
    }

    public final U assertNoValues() {
        return this.assertValueCount(0);
    }

    public final U assertValues(T ... values) {
        int s = this.values.size();
        if (s != values.length) {
            throw this.fail("Value count differs; expected: " + values.length + " " + Arrays.toString(values) + " but was: " + s + " " + this.values);
        }
        for (int i = 0; i < s; ++i) {
            T u = values[i];
            T v = this.values.get(i);
            if (ObjectHelper.equals(u, v)) continue;
            throw this.fail("Values at position " + i + " differ; expected: " + BaseTestConsumer.valueAndClass(u) + " but was: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertValuesOnly(T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertNoErrors()).assertNotComplete();
    }

    public final U assertValueSet(Collection<? extends T> expected) {
        if (expected.isEmpty()) {
            this.assertNoValues();
            return (U)this;
        }
        for (T v : this.values) {
            if (expected.contains(v)) continue;
            throw this.fail("Value not in the expected collection: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertValueSetOnly(Collection<? extends T> expected) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValueSet(expected)).assertNoErrors()).assertNotComplete();
    }

    public final U assertValueSequence(Iterable<? extends T> sequence) {
        boolean actualNext;
        boolean expectedNext;
        int i = 0;
        Iterator<T> actualIterator = this.values.iterator();
        Iterator<T> expectedIterator = sequence.iterator();
        while (true) {
            T v;
            expectedNext = expectedIterator.hasNext();
            actualNext = actualIterator.hasNext();
            if (!actualNext || !expectedNext) break;
            T u = expectedIterator.next();
            if (!ObjectHelper.equals(u, v = actualIterator.next())) {
                throw this.fail("Values at position " + i + " differ; expected: " + BaseTestConsumer.valueAndClass(u) + " but was: " + BaseTestConsumer.valueAndClass(v));
            }
            ++i;
        }
        if (actualNext) {
            throw this.fail("More values received than expected (" + i + ")");
        }
        if (expectedNext) {
            throw this.fail("Fewer values received than expected (" + i + ")");
        }
        return (U)this;
    }

    public final U assertValueSequenceOnly(Iterable<? extends T> sequence) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValueSequence(sequence)).assertNoErrors()).assertNotComplete();
    }

    public final U assertTerminated() {
        if (this.done.getCount() != 0L) {
            throw this.fail("Subscriber still running!");
        }
        long c = this.completions;
        if (c > 1L) {
            throw this.fail("Terminated with multiple completions: " + c);
        }
        int s = this.errors.size();
        if (s > 1) {
            throw this.fail("Terminated with multiple errors: " + s);
        }
        if (c != 0L && s != 0) {
            throw this.fail("Terminated with multiple completions and errors: " + c);
        }
        return (U)this;
    }

    public final U assertNotTerminated() {
        if (this.done.getCount() == 0L) {
            throw this.fail("Subscriber terminated!");
        }
        return (U)this;
    }

    public final boolean awaitTerminalEvent() {
        try {
            this.await();
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final boolean awaitTerminalEvent(long duration, TimeUnit unit) {
        try {
            return this.await(duration, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final U assertErrorMessage(String message) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        if (s == 1) {
            Throwable e = this.errors.get(0);
            String errorMessage = e.getMessage();
            if (!ObjectHelper.equals(message, errorMessage)) {
                throw this.fail("Error message differs; exptected: " + message + " but was: " + errorMessage);
            }
        } else {
            throw this.fail("Multiple errors");
        }
        return (U)this;
    }

    public final List<List<Object>> getEvents() {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        result.add(this.values());
        result.add(this.errors());
        ArrayList completeList = new ArrayList();
        for (long i = 0L; i < this.completions; ++i) {
            completeList.add(Notification.createOnComplete());
        }
        result.add(completeList);
        return result;
    }

    public abstract U assertSubscribed();

    public abstract U assertNotSubscribed();

    public final U assertResult(T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertNoErrors()).assertComplete();
    }

    public final U assertFailure(Class<? extends Throwable> error, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(error)).assertNotComplete();
    }

    public final U assertFailure(Predicate<Throwable> errorPredicate, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(errorPredicate)).assertNotComplete();
    }

    public final U assertFailureAndMessage(Class<? extends Throwable> error, String message, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(error)).assertErrorMessage(message)).assertNotComplete();
    }

    public final U awaitDone(long time, TimeUnit unit) {
        try {
            if (!this.done.await(time, unit)) {
                this.timeout = true;
                this.dispose();
            }
        }
        catch (InterruptedException ex) {
            this.dispose();
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return (U)this;
    }

    public final U assertEmpty() {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertNoValues()).assertNoErrors()).assertNotComplete();
    }

    public final U withTag(CharSequence tag) {
        this.tag = tag;
        return (U)this;
    }

    public final U awaitCount(int atLeast) {
        return this.awaitCount(atLeast, TestWaitStrategy.SLEEP_10MS, 5000L);
    }

    public final U awaitCount(int atLeast, Runnable waitStrategy) {
        return this.awaitCount(atLeast, waitStrategy, 5000L);
    }

    public final U awaitCount(int atLeast, Runnable waitStrategy, long timeoutMillis) {
        long start = System.currentTimeMillis();
        while (true) {
            if (timeoutMillis > 0L && System.currentTimeMillis() - start >= timeoutMillis) {
                this.timeout = true;
                break;
            }
            if (this.done.getCount() == 0L || this.values.size() >= atLeast) break;
            waitStrategy.run();
        }
        return (U)this;
    }

    public final boolean isTimeout() {
        return this.timeout;
    }

    public final U clearTimeout() {
        this.timeout = false;
        return (U)this;
    }

    public final U assertTimeout() {
        if (!this.timeout) {
            throw this.fail("No timeout?!");
        }
        return (U)this;
    }

    public final U assertNoTimeout() {
        if (this.timeout) {
            throw this.fail("Timeout?!");
        }
        return (U)this;
    }

    public static enum TestWaitStrategy implements Runnable
    {
        SPIN{

            @Override
            public void run() {
            }
        }
        ,
        YIELD{

            @Override
            public void run() {
                Thread.yield();
            }
        }
        ,
        SLEEP_1MS{

            @Override
            public void run() {
                3.sleep(1);
            }
        }
        ,
        SLEEP_10MS{

            @Override
            public void run() {
                4.sleep(10);
            }
        }
        ,
        SLEEP_100MS{

            @Override
            public void run() {
                5.sleep(100);
            }
        }
        ,
        SLEEP_1000MS{

            @Override
            public void run() {
                6.sleep(1000);
            }
        };


        @Override
        public abstract void run();

        static void sleep(int millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

