/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.extras.rxjava2.maybe;

import io.confluent.shaded.io.netty.channel.Channel;
import io.confluent.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.confluent.shaded.io.reactivex.MaybeEmitter;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.org.asynchttpclient.AsyncHandler;
import io.confluent.shaded.org.asynchttpclient.HttpResponseBodyPart;
import io.confluent.shaded.org.asynchttpclient.HttpResponseStatus;
import io.confluent.shaded.org.asynchttpclient.extras.rxjava2.DisposedException;
import io.confluent.shaded.org.asynchttpclient.netty.request.NettyRequest;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaybeAsyncHandlerBridge<T>
implements AsyncHandler<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMaybeAsyncHandlerBridge.class);
    private static volatile DisposedException sharedDisposed;
    protected final MaybeEmitter<T> emitter;
    private final AtomicBoolean delegateTerminated = new AtomicBoolean();

    protected AbstractMaybeAsyncHandlerBridge(MaybeEmitter<T> emitter) {
        this.emitter = Objects.requireNonNull(emitter);
    }

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onBodyPartReceived(content);
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onStatusReceived(status);
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onTrailingHeadersReceived(headers);
    }

    @Override
    public final Void onCompleted() {
        T result;
        if (this.delegateTerminated.getAndSet(true)) {
            return null;
        }
        try {
            result = this.delegate().onCompleted();
        }
        catch (Throwable t) {
            this.emitOnError(t);
            return null;
        }
        if (!this.emitter.isDisposed()) {
            if (result == null) {
                this.emitter.onComplete();
            } else {
                this.emitter.onSuccess(result);
            }
        }
        return null;
    }

    @Override
    public final void onThrowable(Throwable t) {
        if (this.delegateTerminated.getAndSet(true)) {
            return;
        }
        Throwable error = t;
        try {
            this.delegate().onThrowable(t);
        }
        catch (Throwable x) {
            error = new CompositeException(Arrays.asList(t, x));
        }
        this.emitOnError(error);
    }

    @Override
    public void onHostnameResolutionAttempt(String name) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onHostnameResolutionAttempt(name));
    }

    @Override
    public void onHostnameResolutionSuccess(String name, List<InetSocketAddress> addresses) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onHostnameResolutionSuccess(name, addresses));
    }

    @Override
    public void onHostnameResolutionFailure(String name, Throwable cause) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onHostnameResolutionFailure(name, cause));
    }

    @Override
    public void onTcpConnectAttempt(InetSocketAddress remoteAddress) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTcpConnectAttempt(remoteAddress));
    }

    @Override
    public void onTcpConnectSuccess(InetSocketAddress remoteAddress, Channel connection) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTcpConnectSuccess(remoteAddress, connection));
    }

    @Override
    public void onTcpConnectFailure(InetSocketAddress remoteAddress, Throwable cause) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTcpConnectFailure(remoteAddress, cause));
    }

    @Override
    public void onTlsHandshakeAttempt() {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTlsHandshakeAttempt());
    }

    @Override
    public void onTlsHandshakeSuccess(SSLSession sslSession) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTlsHandshakeSuccess(sslSession));
    }

    @Override
    public void onTlsHandshakeFailure(Throwable cause) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTlsHandshakeFailure(cause));
    }

    @Override
    public void onConnectionPoolAttempt() {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onConnectionPoolAttempt());
    }

    @Override
    public void onConnectionPooled(Channel connection) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onConnectionPooled(connection));
    }

    @Override
    public void onConnectionOffer(Channel connection) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onConnectionOffer(connection));
    }

    @Override
    public void onRequestSend(NettyRequest request) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onRequestSend(request));
    }

    @Override
    public void onRetry() {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onRetry());
    }

    protected final AsyncHandler.State disposed() {
        if (!this.delegateTerminated.getAndSet(true)) {
            DisposedException disposed = sharedDisposed;
            if (disposed == null) {
                disposed = new DisposedException("Subscription has been disposed.");
                StackTraceElement[] stackTrace = disposed.getStackTrace();
                if (stackTrace.length > 0) {
                    disposed.setStackTrace(new StackTraceElement[]{stackTrace[0]});
                }
                sharedDisposed = disposed;
            }
            this.delegate().onThrowable(disposed);
        }
        return AsyncHandler.State.ABORT;
    }

    protected abstract AsyncHandler<? extends T> delegate();

    private void emitOnError(Throwable error) {
        Exceptions.throwIfFatal(error);
        if (!this.emitter.isDisposed()) {
            this.emitter.onError(error);
        } else {
            LOGGER.debug("Not propagating onError after disposal: {}", (Object)error.getMessage(), (Object)error);
        }
    }

    private void executeUnlessEmitterDisposed(Runnable runnable) {
        if (this.emitter.isDisposed()) {
            this.disposed();
        } else {
            runnable.run();
        }
    }
}

