/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.channel;

import io.confluent.shaded.io.netty.channel.Channel;
import io.confluent.shaded.io.netty.channel.ChannelId;
import io.confluent.shaded.io.netty.util.Attribute;
import io.confluent.shaded.io.netty.util.AttributeKey;
import io.confluent.shaded.io.netty.util.Timeout;
import io.confluent.shaded.io.netty.util.Timer;
import io.confluent.shaded.io.netty.util.TimerTask;
import io.confluent.shaded.org.asynchttpclient.AsyncHttpClientConfig;
import io.confluent.shaded.org.asynchttpclient.channel.ChannelPool;
import io.confluent.shaded.org.asynchttpclient.netty.channel.Channels;
import io.confluent.shaded.org.asynchttpclient.util.Assertions;
import io.confluent.shaded.org.asynchttpclient.util.DateUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultChannelPool
implements ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultChannelPool.class);
    private static final AttributeKey<ChannelCreation> CHANNEL_CREATION_ATTRIBUTE_KEY = AttributeKey.valueOf("channelCreation");
    private final ConcurrentHashMap<Object, ConcurrentLinkedDeque<IdleChannel>> partitions = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Timer nettyTimer;
    private final int connectionTtl;
    private final boolean connectionTtlEnabled;
    private final int maxIdleTime;
    private final boolean maxIdleTimeEnabled;
    private final long cleanerPeriod;
    private final PoolLeaseStrategy poolLeaseStrategy;

    public DefaultChannelPool(AsyncHttpClientConfig config, Timer hashedWheelTimer) {
        this(config.getPooledConnectionIdleTimeout(), config.getConnectionTtl(), hashedWheelTimer, config.getConnectionPoolCleanerPeriod());
    }

    public DefaultChannelPool(int maxIdleTime, int connectionTtl, Timer nettyTimer, int cleanerPeriod) {
        this(maxIdleTime, connectionTtl, PoolLeaseStrategy.LIFO, nettyTimer, cleanerPeriod);
    }

    public DefaultChannelPool(int maxIdleTime, int connectionTtl, PoolLeaseStrategy poolLeaseStrategy, Timer nettyTimer, int cleanerPeriod) {
        this.maxIdleTime = maxIdleTime;
        this.connectionTtl = connectionTtl;
        this.connectionTtlEnabled = connectionTtl > 0;
        this.nettyTimer = nettyTimer;
        this.maxIdleTimeEnabled = maxIdleTime > 0;
        this.poolLeaseStrategy = poolLeaseStrategy;
        this.cleanerPeriod = Math.min(cleanerPeriod, Math.min(this.connectionTtlEnabled ? connectionTtl : Integer.MAX_VALUE, this.maxIdleTimeEnabled ? maxIdleTime : Integer.MAX_VALUE));
        if (this.connectionTtlEnabled || this.maxIdleTimeEnabled) {
            this.scheduleNewIdleChannelDetector(new IdleChannelDetector());
        }
    }

    private void scheduleNewIdleChannelDetector(TimerTask task) {
        this.nettyTimer.newTimeout(task, this.cleanerPeriod, TimeUnit.MILLISECONDS);
    }

    private boolean isTtlExpired(Channel channel, long now) {
        if (!this.connectionTtlEnabled) {
            return false;
        }
        ChannelCreation creation = channel.attr(CHANNEL_CREATION_ATTRIBUTE_KEY).get();
        return creation != null && now - creation.creationTime >= (long)this.connectionTtl;
    }

    @Override
    public boolean offer(Channel channel, Object partitionKey) {
        if (this.isClosed.get()) {
            return false;
        }
        long now = DateUtils.unpreciseMillisTime();
        if (this.isTtlExpired(channel, now)) {
            return false;
        }
        boolean offered = this.offer0(channel, partitionKey, now);
        if (this.connectionTtlEnabled && offered) {
            this.registerChannelCreation(channel, partitionKey, now);
        }
        return offered;
    }

    private boolean offer0(Channel channel, Object partitionKey, long now) {
        ConcurrentLinkedDeque partition = this.partitions.get(partitionKey);
        if (partition == null) {
            partition = this.partitions.computeIfAbsent(partitionKey, pk -> new ConcurrentLinkedDeque());
        }
        return partition.offerFirst(new IdleChannel(channel, now));
    }

    private void registerChannelCreation(Channel channel, Object partitionKey, long now) {
        ChannelId id = channel.id();
        Attribute<ChannelCreation> channelCreationAttribute = channel.attr(CHANNEL_CREATION_ATTRIBUTE_KEY);
        if (channelCreationAttribute.get() == null) {
            channelCreationAttribute.set(new ChannelCreation(now, partitionKey));
        }
    }

    @Override
    public Channel poll(Object partitionKey) {
        IdleChannel idleChannel = null;
        ConcurrentLinkedDeque<IdleChannel> partition = this.partitions.get(partitionKey);
        if (partition != null) {
            while (idleChannel == null && (idleChannel = this.poolLeaseStrategy.lease(partition)) != null) {
                if (!Channels.isChannelActive(idleChannel.channel)) {
                    idleChannel = null;
                    LOGGER.trace("Channel is inactive, probably remotely closed!");
                    continue;
                }
                if (idleChannel.takeOwnership()) continue;
                idleChannel = null;
                LOGGER.trace("Couldn't take ownership of channel, probably in the process of being expired!");
            }
        }
        return idleChannel != null ? idleChannel.channel : null;
    }

    @Override
    public boolean removeAll(Channel channel) {
        ChannelCreation creation = this.connectionTtlEnabled ? channel.attr(CHANNEL_CREATION_ATTRIBUTE_KEY).get() : null;
        return !this.isClosed.get() && creation != null && this.partitions.get(creation.partitionKey).remove(new IdleChannel(channel, Long.MIN_VALUE));
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed.get();
    }

    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.partitions.clear();
    }

    private void close(Channel channel) {
        Channels.setDiscard(channel);
        Channels.silentlyCloseChannel(channel);
    }

    private void flushPartition(Object partitionKey, ConcurrentLinkedDeque<IdleChannel> partition) {
        if (partition != null) {
            this.partitions.remove(partitionKey);
            for (IdleChannel idleChannel : partition) {
                this.close(idleChannel.channel);
            }
        }
    }

    @Override
    public void flushPartitions(Predicate<Object> predicate) {
        for (Map.Entry<Object, ConcurrentLinkedDeque<IdleChannel>> partitionsEntry : this.partitions.entrySet()) {
            Object partitionKey = partitionsEntry.getKey();
            if (!predicate.test(partitionKey)) continue;
            this.flushPartition(partitionKey, partitionsEntry.getValue());
        }
    }

    @Override
    public Map<String, Long> getIdleChannelCountPerHost() {
        return this.partitions.values().stream().flatMap(Collection::stream).map(idle -> idle.getChannel().remoteAddress()).filter(a -> a.getClass() == InetSocketAddress.class).map(a -> (InetSocketAddress)a).map(InetSocketAddress::getHostString).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    private final class IdleChannelDetector
    implements TimerTask {
        private IdleChannelDetector() {
        }

        private boolean isIdleTimeoutExpired(IdleChannel idleChannel, long now) {
            return DefaultChannelPool.this.maxIdleTimeEnabled && now - idleChannel.start >= (long)DefaultChannelPool.this.maxIdleTime;
        }

        private List<IdleChannel> expiredChannels(ConcurrentLinkedDeque<IdleChannel> partition, long now) {
            List<IdleChannel> idleTimeoutChannels = null;
            for (IdleChannel idleChannel : partition) {
                boolean isIdleTimeoutExpired = this.isIdleTimeoutExpired(idleChannel, now);
                boolean isRemotelyClosed = !Channels.isChannelActive(idleChannel.channel);
                boolean isTtlExpired = DefaultChannelPool.this.isTtlExpired(idleChannel.channel, now);
                if (!isIdleTimeoutExpired && !isRemotelyClosed && !isTtlExpired) continue;
                LOGGER.debug("Adding Candidate expired Channel {} isIdleTimeoutExpired={} isRemotelyClosed={} isTtlExpired={}", new Object[]{idleChannel.channel, isIdleTimeoutExpired, isRemotelyClosed, isTtlExpired});
                if (idleTimeoutChannels == null) {
                    idleTimeoutChannels = new ArrayList<IdleChannel>(1);
                }
                idleTimeoutChannels.add(idleChannel);
            }
            return idleTimeoutChannels != null ? idleTimeoutChannels : Collections.emptyList();
        }

        private List<IdleChannel> closeChannels(List<IdleChannel> candidates) {
            List<IdleChannel> closedChannels = null;
            for (int i = 0; i < candidates.size(); ++i) {
                IdleChannel idleChannel = candidates.get(i);
                if (idleChannel.takeOwnership()) {
                    LOGGER.debug("Closing Idle Channel {}", (Object)idleChannel.channel);
                    DefaultChannelPool.this.close(idleChannel.channel);
                    if (closedChannels == null) continue;
                    closedChannels.add(idleChannel);
                    continue;
                }
                if (closedChannels != null) continue;
                closedChannels = new ArrayList<IdleChannel>(candidates.size());
                for (int j = 0; j < i; ++j) {
                    closedChannels.add(candidates.get(j));
                }
            }
            return closedChannels != null ? closedChannels : candidates;
        }

        @Override
        public void run(Timeout timeout) {
            if (DefaultChannelPool.this.isClosed.get()) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                for (Object key : DefaultChannelPool.this.partitions.keySet()) {
                    int size = ((ConcurrentLinkedDeque)DefaultChannelPool.this.partitions.get(key)).size();
                    if (size <= 0) continue;
                    LOGGER.debug("Entry count for : {} : {}", key, (Object)size);
                }
            }
            long start = DateUtils.unpreciseMillisTime();
            int closedCount = 0;
            int totalCount = 0;
            for (ConcurrentLinkedDeque partition : DefaultChannelPool.this.partitions.values()) {
                List<IdleChannel> closedChannels;
                if (LOGGER.isDebugEnabled()) {
                    totalCount += partition.size();
                }
                if ((closedChannels = this.closeChannels(this.expiredChannels(partition, start))).isEmpty()) continue;
                partition.removeAll(closedChannels);
                closedCount += closedChannels.size();
            }
            if (LOGGER.isDebugEnabled()) {
                long duration = DateUtils.unpreciseMillisTime() - start;
                if (closedCount > 0) {
                    LOGGER.debug("Closed {} connections out of {} in {} ms", new Object[]{closedCount, totalCount, duration});
                }
            }
            DefaultChannelPool.this.scheduleNewIdleChannelDetector(timeout.task());
        }
    }

    private static final class IdleChannel {
        private static final AtomicIntegerFieldUpdater<IdleChannel> ownedField = AtomicIntegerFieldUpdater.newUpdater(IdleChannel.class, "owned");
        final Channel channel;
        final long start;
        private volatile int owned = 0;

        IdleChannel(Channel channel, long start) {
            this.channel = Assertions.assertNotNull(channel, "channel");
            this.start = start;
        }

        public boolean takeOwnership() {
            return ownedField.getAndSet(this, 1) == 0;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IdleChannel && this.channel.equals(((IdleChannel)IdleChannel.class.cast((Object)o)).channel);
        }

        public int hashCode() {
            return this.channel.hashCode();
        }
    }

    private static final class ChannelCreation {
        final long creationTime;
        final Object partitionKey;

        ChannelCreation(long creationTime, Object partitionKey) {
            this.creationTime = creationTime;
            this.partitionKey = partitionKey;
        }
    }

    public static enum PoolLeaseStrategy {
        LIFO{

            @Override
            public <E> E lease(Deque<E> d) {
                return d.pollFirst();
            }
        }
        ,
        FIFO{

            @Override
            public <E> E lease(Deque<E> d) {
                return d.pollLast();
            }
        };


        abstract <E> E lease(Deque<E> var1);
    }
}

