/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.request.body.generator;

import io.confluent.shaded.io.netty.buffer.ByteBuf;
import io.confluent.shaded.io.netty.buffer.Unpooled;
import io.confluent.shaded.org.asynchttpclient.request.body.Body;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.FeedListener;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import io.confluent.shaded.org.asynchttpclient.util.Assertions;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsBodyGenerator
implements FeedableBodyGenerator {
    private final Publisher<ByteBuf> publisher;
    private final FeedableBodyGenerator feedableBodyGenerator;
    private final long contentLength;
    private volatile FeedListener feedListener;

    public ReactiveStreamsBodyGenerator(Publisher<ByteBuf> publisher, long contentLength) {
        this.publisher = publisher;
        this.feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
        this.contentLength = contentLength;
    }

    public Publisher<ByteBuf> getPublisher() {
        return this.publisher;
    }

    @Override
    public boolean feed(ByteBuf buffer, boolean isLast) throws Exception {
        return this.feedableBodyGenerator.feed(buffer, isLast);
    }

    @Override
    public void setListener(FeedListener listener) {
        this.feedListener = listener;
        this.feedableBodyGenerator.setListener(listener);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public Body createBody() {
        return new StreamedBody(this.feedableBodyGenerator, this.contentLength);
    }

    private class SimpleSubscriber
    implements Subscriber<ByteBuf> {
        private final Logger LOGGER = LoggerFactory.getLogger(SimpleSubscriber.class);
        private final FeedableBodyGenerator feeder;
        private volatile Subscription subscription;

        public SimpleSubscriber(FeedableBodyGenerator feeder) {
            this.feeder = feeder;
        }

        @Override
        public void onSubscribe(Subscription s) {
            Assertions.assertNotNull(s, "subscription");
            if (this.subscription != null) {
                s.cancel();
            } else {
                this.subscription = s;
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(ByteBuf b) {
            Assertions.assertNotNull(b, "bytebuf");
            try {
                this.feeder.feed(b, false);
            }
            catch (Exception e) {
                this.LOGGER.error("Exception occurred while processing element in stream.", (Throwable)e);
                this.subscription.cancel();
            }
        }

        @Override
        public void onError(Throwable t) {
            Assertions.assertNotNull(t, "throwable");
            this.LOGGER.debug("Error occurred while consuming body stream.", t);
            FeedListener listener = ReactiveStreamsBodyGenerator.this.feedListener;
            if (listener != null) {
                listener.onError(t);
            }
        }

        @Override
        public void onComplete() {
            try {
                this.feeder.feed(Unpooled.EMPTY_BUFFER, true);
            }
            catch (Exception e) {
                this.LOGGER.info("Ignoring exception occurred while completing stream processing.", (Throwable)e);
                this.subscription.cancel();
            }
        }
    }

    private class StreamedBody
    implements Body {
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private final SimpleSubscriber subscriber;
        private final Body body;
        private final long contentLength;

        public StreamedBody(FeedableBodyGenerator bodyGenerator, long contentLength) {
            this.body = bodyGenerator.createBody();
            this.subscriber = new SimpleSubscriber(bodyGenerator);
            this.contentLength = contentLength;
        }

        @Override
        public void close() throws IOException {
            this.body.close();
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            if (this.initialized.compareAndSet(false, true)) {
                ReactiveStreamsBodyGenerator.this.publisher.subscribe(this.subscriber);
            }
            return this.body.transferTo(target);
        }
    }
}

