/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.client;

import io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientStats;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public class BufferingAsyncTelemetryHttpClientStatsCollector {
    private final AtomicLong totalDroppedBatches = new AtomicLong();
    private final AtomicLong totalBatches = new AtomicLong();
    private final AtomicLong totalItems = new AtomicLong();
    private final AtomicLong totalSendTimeMs = new AtomicLong();
    private final AtomicLong totalSuccessfulBatches = new AtomicLong();
    private final AtomicLong totalSuccessfulItems = new AtomicLong();
    private final AtomicLong totalFailedBatches = new AtomicLong();
    private final AtomicLong totalFailedItems = new AtomicLong();

    public long recordBatch(long size) {
        long batchId = this.totalBatches.incrementAndGet();
        this.totalItems.addAndGet(size);
        return batchId;
    }

    public void recordDroppedBatch() {
        this.totalDroppedBatches.incrementAndGet();
    }

    public void recordSuccessfulBatch(long size, Instant sendStart) {
        this.totalSuccessfulBatches.incrementAndGet();
        this.totalSuccessfulItems.addAndGet(size);
        this.totalSendTimeMs.addAndGet(Duration.between(sendStart, Instant.now()).toMillis());
    }

    public void recordFailedBatch(long size, Instant sendStart) {
        this.totalFailedBatches.incrementAndGet();
        this.totalFailedItems.addAndGet(size);
        this.totalSendTimeMs.addAndGet(Duration.between(sendStart, Instant.now()).toMillis());
    }

    public BufferingAsyncTelemetryHttpClientStats snapshot() {
        return new BufferingAsyncTelemetryHttpClientStats(this.totalDroppedBatches.get(), this.totalBatches.get(), this.totalItems.get(), this.totalSendTimeMs.get(), this.totalSuccessfulBatches.get(), this.totalSuccessfulItems.get(), this.totalFailedBatches.get(), this.totalFailedItems.get());
    }
}

