/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.ClusterLinkChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class ClusterLinkChangeRecordJsonConverter {
    public static ClusterLinkChangeRecord read(JsonNode _node, short _version) {
        ClusterLinkChangeRecord _object = new ClusterLinkChangeRecord();
        JsonNode _clusterLinkNameNode = _node.get("clusterLinkName");
        if (_clusterLinkNameNode == null) {
            throw new RuntimeException("ClusterLinkChangeRecord: unable to locate field 'clusterLinkName', which is mandatory in version " + _version);
        }
        if (!_clusterLinkNameNode.isTextual()) {
            throw new RuntimeException("ClusterLinkChangeRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.clusterLinkName = _clusterLinkNameNode.asText();
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            throw new RuntimeException("ClusterLinkChangeRecord: unable to locate field 'clusterLinkId', which is mandatory in version " + _version);
        }
        if (!_clusterLinkIdNode.isTextual()) {
            throw new RuntimeException("ClusterLinkChangeRecord expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.clusterLinkId = Uuid.fromString((String)_clusterLinkIdNode.asText());
        JsonNode _remoteClusterIdNode = _node.get("remoteClusterId");
        if (_remoteClusterIdNode == null) {
            throw new RuntimeException("ClusterLinkChangeRecord: unable to locate field 'remoteClusterId', which is mandatory in version " + _version);
        }
        if (!_remoteClusterIdNode.isTextual()) {
            throw new RuntimeException("ClusterLinkChangeRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.remoteClusterId = _remoteClusterIdNode.asText();
        JsonNode _tenantPrefixNode = _node.get("tenantPrefix");
        if (_tenantPrefixNode == null) {
            _object.tenantPrefix = null;
        } else if (_tenantPrefixNode.isNull()) {
            _object.tenantPrefix = null;
        } else {
            if (!_tenantPrefixNode.isTextual()) {
                throw new RuntimeException("ClusterLinkChangeRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.tenantPrefix = _tenantPrefixNode.asText();
        }
        JsonNode _linkModeNode = _node.get("linkMode");
        if (_linkModeNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("ClusterLinkChangeRecord: unable to locate field 'linkMode', which is mandatory in version " + _version);
            }
            _object.linkMode = "DESTINATION";
        } else {
            if (!_linkModeNode.isTextual()) {
                throw new RuntimeException("ClusterLinkChangeRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.linkMode = _linkModeNode.asText();
        }
        JsonNode _switchoverMetadataNode = _node.get("switchoverMetadata");
        if (_switchoverMetadataNode == null) {
            throw new RuntimeException("ClusterLinkChangeRecord: unable to locate field 'switchoverMetadata', which is mandatory in version " + _version);
        }
        _object.switchoverMetadata = _switchoverMetadataNode.isNull() ? null : ClusterLinkSwitchoverMetadataRecordJsonConverter.read(_switchoverMetadataNode, _version);
        return _object;
    }

    public static JsonNode write(ClusterLinkChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("clusterLinkName", (JsonNode)new TextNode(_object.clusterLinkName));
        _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        _node.set("remoteClusterId", (JsonNode)new TextNode(_object.remoteClusterId));
        if (_object.tenantPrefix != null) {
            _node.set("tenantPrefix", (JsonNode)new TextNode(_object.tenantPrefix));
        }
        if (_version >= 1) {
            _node.set("linkMode", (JsonNode)new TextNode(_object.linkMode));
        } else if (!_object.linkMode.equals("DESTINATION")) {
            throw new UnsupportedVersionException("Attempted to write a non-default linkMode at version " + _version);
        }
        if (_object.switchoverMetadata == null) {
            _node.set("switchoverMetadata", (JsonNode)NullNode.instance);
        } else {
            _node.set("switchoverMetadata", ClusterLinkSwitchoverMetadataRecordJsonConverter.write(_object.switchoverMetadata, _version, _serializeRecords));
        }
        return _node;
    }

    public static JsonNode write(ClusterLinkChangeRecord _object, short _version) {
        return ClusterLinkChangeRecordJsonConverter.write(_object, _version, true);
    }

    public static class ClusterLinkSwitchoverMetadataRecordJsonConverter {
        public static ClusterLinkChangeRecord.ClusterLinkSwitchoverMetadataRecord read(JsonNode _node, short _version) {
            ClusterLinkChangeRecord.ClusterLinkSwitchoverMetadataRecord _object = new ClusterLinkChangeRecord.ClusterLinkSwitchoverMetadataRecord();
            JsonNode _switchoverTypeNode = _node.get("switchoverType");
            if (_switchoverTypeNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'switchoverType', which is mandatory in version " + _version);
            }
            _object.switchoverType = MessageUtil.jsonNodeToByte((JsonNode)_switchoverTypeNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _switchoverTimestampNode = _node.get("switchoverTimestamp");
            if (_switchoverTimestampNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'switchoverTimestamp', which is mandatory in version " + _version);
            }
            _object.switchoverTimestamp = MessageUtil.jsonNodeToLong((JsonNode)_switchoverTimestampNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _switchoverStateNode = _node.get("switchoverState");
            if (_switchoverStateNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'switchoverState', which is mandatory in version " + _version);
            }
            _object.switchoverState = MessageUtil.jsonNodeToByte((JsonNode)_switchoverStateNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort((JsonNode)_errorCodeNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.errorMessage = _errorMessageNode.asText();
            JsonNode _controlPlaneTimestampNode = _node.get("controlPlaneTimestamp");
            _object.controlPlaneTimestamp = _controlPlaneTimestampNode == null ? 0L : MessageUtil.jsonNodeToLong((JsonNode)_controlPlaneTimestampNode, (String)"ClusterLinkSwitchoverMetadataRecord");
            JsonNode _isDeletedNode = _node.get("isDeleted");
            if (_isDeletedNode == null) {
                _object.isDeleted = false;
            } else {
                if (!_isDeletedNode.isBoolean()) {
                    throw new RuntimeException("ClusterLinkSwitchoverMetadataRecord expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.isDeleted = _isDeletedNode.asBoolean();
            }
            return _object;
        }

        public static JsonNode write(ClusterLinkChangeRecord.ClusterLinkSwitchoverMetadataRecord _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("switchoverType", (JsonNode)new ShortNode((short)_object.switchoverType));
            _node.set("switchoverTimestamp", (JsonNode)new LongNode(_object.switchoverTimestamp));
            _node.set("switchoverState", (JsonNode)new ShortNode((short)_object.switchoverState));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            if (_version >= 1) {
                if (_object.controlPlaneTimestamp != 0L) {
                    _node.set("controlPlaneTimestamp", (JsonNode)new LongNode(_object.controlPlaneTimestamp));
                }
            } else if (_object.controlPlaneTimestamp != 0L) {
                throw new UnsupportedVersionException("Attempted to write a non-default controlPlaneTimestamp at version " + _version);
            }
            if (_version >= 1) {
                if (_object.isDeleted) {
                    _node.set("isDeleted", (JsonNode)BooleanNode.valueOf((boolean)_object.isDeleted));
                }
            } else if (_object.isDeleted) {
                throw new UnsupportedVersionException("Attempted to write a non-default isDeleted at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(ClusterLinkChangeRecord.ClusterLinkSwitchoverMetadataRecord _object, short _version) {
            return ClusterLinkSwitchoverMetadataRecordJsonConverter.write(_object, _version, true);
        }
    }
}

