/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ClusterLinkRecord
implements ApiMessage {
    String clusterLinkName;
    Uuid clusterLinkId;
    String remoteClusterId;
    String tenantPrefix;
    String linkMode;
    ClusterLinkSwitchoverMetadataRecord switchoverMetadata;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("remote_cluster_id", (Type)Type.COMPACT_STRING, "The ID of the remote cluster for this cluster link."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("tenant_prefix", (Type)Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null")})});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("remote_cluster_id", (Type)Type.COMPACT_STRING, "The ID of the remote cluster for this cluster link."), new Field("link_mode", (Type)Type.COMPACT_STRING, "The mode of this cluster link. It can be either a destination initiated or source initiated cluster link."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("tenant_prefix", (Type)Type.COMPACT_NULLABLE_STRING, "The tenant prefix of this cluster link if it exists. Default is null"), 1, new Field("switchover_metadata", (Type)ClusterLinkSwitchoverMetadataRecord.SCHEMA_1, "Switchover metadata for this cluster link. Default is null")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ClusterLinkRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ClusterLinkRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ClusterLinkRecord() {
        this.clusterLinkName = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.remoteClusterId = "";
        this.tenantPrefix = null;
        this.linkMode = "DESTINATION";
        this.switchoverMetadata = null;
    }

    public short apiKey() {
        return 10000;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _readable.readString(length);
        this.clusterLinkId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field remoteClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field remoteClusterId had invalid length " + length);
        }
        this.remoteClusterId = _readable.readString(length);
        this.tenantPrefix = null;
        if (_version >= 1) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkMode was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkMode had invalid length " + length);
            }
            this.linkMode = _readable.readString(length);
        } else {
            this.linkMode = "DESTINATION";
        }
        this.switchoverMetadata = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.tenantPrefix = null;
                        continue block4;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field tenantPrefix had invalid length " + length2);
                    }
                    this.tenantPrefix = _readable.readString(length2);
                    continue block4;
                }
                case 1: {
                    if (_version >= 1) {
                        if (_readable.readUnsignedVarint() <= 0) {
                            this.switchoverMetadata = null;
                            continue block4;
                        }
                        this.switchoverMetadata = new ClusterLinkSwitchoverMetadataRecord(_readable, _version, _context);
                        continue block4;
                    }
                    throw new RuntimeException("Tag 1 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUuid(this.clusterLinkId);
        _stringBytes = _cache.getSerializedValue((Object)this.remoteClusterId);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        if (this.tenantPrefix != null) {
            ++_numTaggedFields;
        }
        if (_version >= 1) {
            _stringBytes = _cache.getSerializedValue((Object)this.linkMode);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        } else if (!this.linkMode.equals("DESTINATION")) {
            throw new UnsupportedVersionException("Attempted to write a non-default linkMode at version " + _version);
        }
        if (_version >= 1) {
            if (this.switchoverMetadata != null) {
                ++_numTaggedFields;
            }
        } else if (this.switchoverMetadata != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default switchoverMetadata at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.tenantPrefix != null) {
            _writable.writeUnsignedVarint(0);
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.tenantPrefix);
            _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        if (_version >= 1 && this.switchoverMetadata != null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(this.switchoverMetadata.size(_cache, _version, _context) + 1);
            _writable.writeUnsignedVarint(1);
            this.switchoverMetadata.write(_writable, _cache, _version, _context);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.clusterLinkName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = this.remoteClusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'remoteClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.remoteClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.tenantPrefix != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.tenantPrefix.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantPrefix' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.tenantPrefix, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (_version >= 1) {
            _stringBytes = this.linkMode.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkMode' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.linkMode, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        if (_version >= 1 && this.switchoverMetadata != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeStruct = _size.totalSize();
            _size.addBytes(1);
            this.switchoverMetadata.addSize(_size, _cache, _version, _context);
            int _structSize = _size.totalSize() - _sizeBeforeStruct;
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_structSize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterLinkRecord)) {
            return false;
        }
        ClusterLinkRecord other = (ClusterLinkRecord)obj;
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.remoteClusterId == null ? other.remoteClusterId != null : !this.remoteClusterId.equals(other.remoteClusterId)) {
            return false;
        }
        if (this.tenantPrefix == null ? other.tenantPrefix != null : !this.tenantPrefix.equals(other.tenantPrefix)) {
            return false;
        }
        if (this.linkMode == null ? other.linkMode != null : !this.linkMode.equals(other.linkMode)) {
            return false;
        }
        if (this.switchoverMetadata == null ? other.switchoverMetadata != null : !this.switchoverMetadata.equals(other.switchoverMetadata)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.remoteClusterId == null ? 0 : this.remoteClusterId.hashCode());
        hashCode = 31 * hashCode + (this.tenantPrefix == null ? 0 : this.tenantPrefix.hashCode());
        hashCode = 31 * hashCode + (this.linkMode == null ? 0 : this.linkMode.hashCode());
        hashCode = 31 * hashCode + (this.switchoverMetadata == null ? 0 : this.switchoverMetadata.hashCode());
        return hashCode;
    }

    public ClusterLinkRecord duplicate() {
        ClusterLinkRecord _duplicate = new ClusterLinkRecord();
        _duplicate.clusterLinkName = this.clusterLinkName;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.remoteClusterId = this.remoteClusterId;
        _duplicate.tenantPrefix = this.tenantPrefix == null ? null : this.tenantPrefix;
        _duplicate.linkMode = this.linkMode;
        _duplicate.switchoverMetadata = this.switchoverMetadata == null ? null : this.switchoverMetadata.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "ClusterLinkRecord(clusterLinkName=" + (String)(this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", remoteClusterId=" + (String)(this.remoteClusterId == null ? "null" : "'" + this.remoteClusterId.toString() + "'") + ", tenantPrefix=" + (String)(this.tenantPrefix == null ? "null" : "'" + this.tenantPrefix.toString() + "'") + ", linkMode=" + (String)(this.linkMode == null ? "null" : "'" + this.linkMode.toString() + "'") + ", switchoverMetadata=" + (this.switchoverMetadata == null ? "null" : this.switchoverMetadata.toString()) + ")";
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String tenantPrefix() {
        return this.tenantPrefix;
    }

    public String linkMode() {
        return this.linkMode;
    }

    public ClusterLinkSwitchoverMetadataRecord switchoverMetadata() {
        return this.switchoverMetadata;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ClusterLinkRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }

    public ClusterLinkRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public ClusterLinkRecord setRemoteClusterId(String v) {
        this.remoteClusterId = v;
        return this;
    }

    public ClusterLinkRecord setTenantPrefix(String v) {
        this.tenantPrefix = v;
        return this;
    }

    public ClusterLinkRecord setLinkMode(String v) {
        this.linkMode = v;
        return this;
    }

    public ClusterLinkRecord setSwitchoverMetadata(ClusterLinkSwitchoverMetadataRecord v) {
        this.switchoverMetadata = v;
        return this;
    }

    public static class ClusterLinkSwitchoverMetadataRecord
    implements Message {
        byte switchoverType;
        long switchoverTimestamp;
        byte switchoverState;
        short errorCode;
        String errorMessage;
        long controlPlaneTimestamp;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("switchover_type", (Type)Type.INT8, "The most recent type of switchover: FAILOVER, REVERSE, or RESTORE."), new Field("switchover_timestamp", (Type)Type.INT64, "The time that the last switchover was initiated."), new Field("switchover_state", (Type)Type.INT8, "Whether the switchover is currently the active, passive, or in progress of changing into one of those states."), new Field("error_code", (Type)Type.INT16, "Link-level error code for the switchover operation."), new Field("error_message", (Type)Type.COMPACT_STRING, "Link-level error message for the switchover operation."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("control_plane_timestamp", (Type)Type.INT64, "The time when control plane receives the switchover info.")})});
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ClusterLinkSwitchoverMetadataRecord(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ClusterLinkSwitchoverMetadataRecord() {
            this.switchoverType = 0;
            this.switchoverTimestamp = 0L;
            this.switchoverState = 0;
            this.errorCode = 0;
            this.errorMessage = "";
            this.controlPlaneTimestamp = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClusterLinkSwitchoverMetadataRecord");
            }
            this.switchoverType = _readable.readByte();
            this.switchoverTimestamp = _readable.readLong();
            this.switchoverState = _readable.readByte();
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field errorMessage was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
            this.controlPlaneTimestamp = 0L;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        this.controlPlaneTimestamp = _readable.readLong();
                        continue block3;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClusterLinkSwitchoverMetadataRecord");
            }
            int _numTaggedFields = 0;
            _writable.writeByte(this.switchoverType);
            _writable.writeLong(this.switchoverTimestamp);
            _writable.writeByte(this.switchoverState);
            _writable.writeShort(this.errorCode);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            if (this.controlPlaneTimestamp != 0L) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (this.controlPlaneTimestamp != 0L) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.controlPlaneTimestamp);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ClusterLinkSwitchoverMetadataRecord");
            }
            _size.addBytes(1);
            _size.addBytes(8);
            _size.addBytes(1);
            _size.addBytes(2);
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this.controlPlaneTimestamp != 0L) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClusterLinkSwitchoverMetadataRecord)) {
                return false;
            }
            ClusterLinkSwitchoverMetadataRecord other = (ClusterLinkSwitchoverMetadataRecord)obj;
            if (this.switchoverType != other.switchoverType) {
                return false;
            }
            if (this.switchoverTimestamp != other.switchoverTimestamp) {
                return false;
            }
            if (this.switchoverState != other.switchoverState) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.controlPlaneTimestamp != other.controlPlaneTimestamp) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.switchoverType;
            hashCode = 31 * hashCode + ((int)(this.switchoverTimestamp >> 32) ^ (int)this.switchoverTimestamp);
            hashCode = 31 * hashCode + this.switchoverState;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + ((int)(this.controlPlaneTimestamp >> 32) ^ (int)this.controlPlaneTimestamp);
            return hashCode;
        }

        public ClusterLinkSwitchoverMetadataRecord duplicate() {
            ClusterLinkSwitchoverMetadataRecord _duplicate = new ClusterLinkSwitchoverMetadataRecord();
            _duplicate.switchoverType = this.switchoverType;
            _duplicate.switchoverTimestamp = this.switchoverTimestamp;
            _duplicate.switchoverState = this.switchoverState;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage;
            _duplicate.controlPlaneTimestamp = this.controlPlaneTimestamp;
            return _duplicate;
        }

        public String toString() {
            return "ClusterLinkSwitchoverMetadataRecord(switchoverType=" + this.switchoverType + ", switchoverTimestamp=" + this.switchoverTimestamp + ", switchoverState=" + this.switchoverState + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", controlPlaneTimestamp=" + this.controlPlaneTimestamp + ")";
        }

        public byte switchoverType() {
            return this.switchoverType;
        }

        public long switchoverTimestamp() {
            return this.switchoverTimestamp;
        }

        public byte switchoverState() {
            return this.switchoverState;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public long controlPlaneTimestamp() {
            return this.controlPlaneTimestamp;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ClusterLinkSwitchoverMetadataRecord setSwitchoverType(byte v) {
            this.switchoverType = v;
            return this;
        }

        public ClusterLinkSwitchoverMetadataRecord setSwitchoverTimestamp(long v) {
            this.switchoverTimestamp = v;
            return this;
        }

        public ClusterLinkSwitchoverMetadataRecord setSwitchoverState(byte v) {
            this.switchoverState = v;
            return this;
        }

        public ClusterLinkSwitchoverMetadataRecord setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ClusterLinkSwitchoverMetadataRecord setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public ClusterLinkSwitchoverMetadataRecord setControlPlaneTimestamp(long v) {
            this.controlPlaneTimestamp = v;
            return this;
        }
    }
}

