/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ConfluentKeyValueStreamChangeRecord
implements ApiMessage {
    short type;
    short partition;
    long offset;
    String entryKey;
    String entryValue;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("type", (Type)Type.INT16, "Internal topic type"), new Field("partition", (Type)Type.INT16, "Partition id of this record"), new Field("offset", (Type)Type.INT64, "The offset of this record in the partition"), new Field("entry_key", (Type)Type.COMPACT_STRING, "String representation of the internal topic key"), new Field("entry_value", (Type)Type.COMPACT_STRING, "String representation of the internal topic value. Empty value means deletion"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ConfluentKeyValueStreamChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ConfluentKeyValueStreamChangeRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ConfluentKeyValueStreamChangeRecord() {
        this.type = 0;
        this.partition = 0;
        this.offset = 0L;
        this.entryKey = "";
        this.entryValue = "";
    }

    public short apiKey() {
        return 10022;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.type = _readable.readShort();
        this.partition = _readable.readShort();
        this.offset = _readable.readLong();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field entryKey was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field entryKey had invalid length " + length);
        }
        this.entryKey = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field entryValue was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field entryValue had invalid length " + length);
        }
        this.entryValue = _readable.readString(length);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.type);
        _writable.writeShort(this.partition);
        _writable.writeLong(this.offset);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.entryKey);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.entryValue);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(2);
        _size.addBytes(8);
        byte[] _stringBytes = this.entryKey.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'entryKey' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.entryKey, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.entryValue.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'entryValue' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.entryValue, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfluentKeyValueStreamChangeRecord)) {
            return false;
        }
        ConfluentKeyValueStreamChangeRecord other = (ConfluentKeyValueStreamChangeRecord)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.partition != other.partition) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.entryKey == null ? other.entryKey != null : !this.entryKey.equals(other.entryKey)) {
            return false;
        }
        if (this.entryValue == null ? other.entryValue != null : !this.entryValue.equals(other.entryValue)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.type;
        hashCode = 31 * hashCode + this.partition;
        hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
        hashCode = 31 * hashCode + (this.entryKey == null ? 0 : this.entryKey.hashCode());
        hashCode = 31 * hashCode + (this.entryValue == null ? 0 : this.entryValue.hashCode());
        return hashCode;
    }

    public ConfluentKeyValueStreamChangeRecord duplicate() {
        ConfluentKeyValueStreamChangeRecord _duplicate = new ConfluentKeyValueStreamChangeRecord();
        _duplicate.type = this.type;
        _duplicate.partition = this.partition;
        _duplicate.offset = this.offset;
        _duplicate.entryKey = this.entryKey;
        _duplicate.entryValue = this.entryValue;
        return _duplicate;
    }

    public String toString() {
        return "ConfluentKeyValueStreamChangeRecord(type=" + this.type + ", partition=" + this.partition + ", offset=" + this.offset + ", entryKey=" + (String)(this.entryKey == null ? "null" : "'" + this.entryKey.toString() + "'") + ", entryValue=" + (String)(this.entryValue == null ? "null" : "'" + this.entryValue.toString() + "'") + ")";
    }

    public short type() {
        return this.type;
    }

    public short partition() {
        return this.partition;
    }

    public long offset() {
        return this.offset;
    }

    public String entryKey() {
        return this.entryKey;
    }

    public String entryValue() {
        return this.entryValue;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConfluentKeyValueStreamChangeRecord setType(short v) {
        this.type = v;
        return this;
    }

    public ConfluentKeyValueStreamChangeRecord setPartition(short v) {
        this.partition = v;
        return this;
    }

    public ConfluentKeyValueStreamChangeRecord setOffset(long v) {
        this.offset = v;
        return this;
    }

    public ConfluentKeyValueStreamChangeRecord setEntryKey(String v) {
        this.entryKey = v;
        return this;
    }

    public ConfluentKeyValueStreamChangeRecord setEntryValue(String v) {
        this.entryValue = v;
        return this;
    }
}

