/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.util.ArrayList;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamTopicRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class ConfluentKeyValueStreamTopicRecordJsonConverter {
    public static ConfluentKeyValueStreamTopicRecord read(JsonNode _node, short _version) {
        ConfluentKeyValueStreamTopicRecord _object = new ConfluentKeyValueStreamTopicRecord();
        JsonNode _typeNode = _node.get("type");
        if (_typeNode == null) {
            throw new RuntimeException("ConfluentKeyValueStreamTopicRecord: unable to locate field 'type', which is mandatory in version " + _version);
        }
        _object.type = MessageUtil.jsonNodeToShort((JsonNode)_typeNode, (String)"ConfluentKeyValueStreamTopicRecord");
        JsonNode _partitionsNode = _node.get("partitions");
        if (_partitionsNode == null) {
            throw new RuntimeException("ConfluentKeyValueStreamTopicRecord: unable to locate field 'partitions', which is mandatory in version " + _version);
        }
        if (!_partitionsNode.isArray()) {
            throw new RuntimeException("ConfluentKeyValueStreamTopicRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ConfluentKeyValueStreamTopicRecord.Partition> _collection = new ArrayList<ConfluentKeyValueStreamTopicRecord.Partition>(_partitionsNode.size());
        _object.partitions = _collection;
        for (JsonNode _element : _partitionsNode) {
            _collection.add(PartitionJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ConfluentKeyValueStreamTopicRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("type", (JsonNode)new ShortNode(_object.type));
        ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ConfluentKeyValueStreamTopicRecord.Partition _element : _object.partitions) {
            _partitionsArray.add(PartitionJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("partitions", (JsonNode)_partitionsArray);
        return _node;
    }

    public static JsonNode write(ConfluentKeyValueStreamTopicRecord _object, short _version) {
        return ConfluentKeyValueStreamTopicRecordJsonConverter.write(_object, _version, true);
    }

    public static class PartitionJsonConverter {
        public static ConfluentKeyValueStreamTopicRecord.Partition read(JsonNode _node, short _version) {
            ConfluentKeyValueStreamTopicRecord.Partition _object = new ConfluentKeyValueStreamTopicRecord.Partition();
            JsonNode _idNode = _node.get("id");
            if (_idNode == null) {
                throw new RuntimeException("Partition: unable to locate field 'id', which is mandatory in version " + _version);
            }
            _object.id = MessageUtil.jsonNodeToShort((JsonNode)_idNode, (String)"Partition");
            JsonNode _offsetNode = _node.get("offset");
            if (_offsetNode == null) {
                throw new RuntimeException("Partition: unable to locate field 'offset', which is mandatory in version " + _version);
            }
            _object.offset = MessageUtil.jsonNodeToLong((JsonNode)_offsetNode, (String)"Partition");
            return _object;
        }

        public static JsonNode write(ConfluentKeyValueStreamTopicRecord.Partition _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("id", (JsonNode)new ShortNode(_object.id));
            _node.set("offset", (JsonNode)new LongNode(_object.offset));
            return _node;
        }

        public static JsonNode write(ConfluentKeyValueStreamTopicRecord.Partition _object, short _version) {
            return PartitionJsonConverter.write(_object, _version, true);
        }
    }
}

