/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class PartitionRecordJsonConverter {
    public static PartitionRecord read(JsonNode _node, short _version) {
        PartitionRecord _object = new PartitionRecord();
        JsonNode _partitionIdNode = _node.get("partitionId");
        if (_partitionIdNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'partitionId', which is mandatory in version " + _version);
        }
        _object.partitionId = MessageUtil.jsonNodeToInt((JsonNode)_partitionIdNode, (String)"PartitionRecord");
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("PartitionRecord expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _replicasNode = _node.get("replicas");
        if (_replicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'replicas', which is mandatory in version " + _version);
        }
        if (!_replicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<Integer> _collection = new ArrayList<Integer>(_replicasNode.size());
        _object.replicas = _collection;
        for (Object _element : _replicasNode) {
            _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _isrNode = _node.get("isr");
        if (_isrNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'isr', which is mandatory in version " + _version);
        }
        if (!_isrNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<Integer> _collection2 = new ArrayList<Integer>(_isrNode.size());
        _object.isr = _collection2;
        for (Object _element : _isrNode) {
            _collection2.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _removingReplicasNode = _node.get("removingReplicas");
        if (_removingReplicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'removingReplicas', which is mandatory in version " + _version);
        }
        if (!_removingReplicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<Integer> _collection3 = new ArrayList<Integer>(_removingReplicasNode.size());
        _object.removingReplicas = _collection3;
        for (Object _element : _removingReplicasNode) {
            _collection3.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _addingReplicasNode = _node.get("addingReplicas");
        if (_addingReplicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'addingReplicas', which is mandatory in version " + _version);
        }
        if (!_addingReplicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<Integer> _collection4 = new ArrayList<Integer>(_addingReplicasNode.size());
        _object.addingReplicas = _collection4;
        for (JsonNode _element : _addingReplicasNode) {
            _collection4.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _leaderNode = _node.get("leader");
        if (_leaderNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'leader', which is mandatory in version " + _version);
        }
        _object.leader = MessageUtil.jsonNodeToInt((JsonNode)_leaderNode, (String)"PartitionRecord");
        JsonNode _leaderRecoveryStateNode = _node.get("leaderRecoveryState");
        _object.leaderRecoveryState = _leaderRecoveryStateNode == null ? (byte)0 : MessageUtil.jsonNodeToByte((JsonNode)_leaderRecoveryStateNode, (String)"PartitionRecord");
        JsonNode _leaderEpochNode = _node.get("leaderEpoch");
        if (_leaderEpochNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
        }
        _object.leaderEpoch = MessageUtil.jsonNodeToInt((JsonNode)_leaderEpochNode, (String)"PartitionRecord");
        JsonNode _partitionEpochNode = _node.get("partitionEpoch");
        if (_partitionEpochNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'partitionEpoch', which is mandatory in version " + _version);
        }
        _object.partitionEpoch = MessageUtil.jsonNodeToInt((JsonNode)_partitionEpochNode, (String)"PartitionRecord");
        JsonNode _linkedLeaderEpochNode = _node.get("linkedLeaderEpoch");
        _object.linkedLeaderEpoch = _linkedLeaderEpochNode == null ? -1 : MessageUtil.jsonNodeToInt((JsonNode)_linkedLeaderEpochNode, (String)"PartitionRecord");
        JsonNode _linkStateNode = _node.get("linkState");
        _object.linkState = _linkStateNode == null ? (byte)-1 : MessageUtil.jsonNodeToByte((JsonNode)_linkStateNode, (String)"PartitionRecord");
        JsonNode _observersNode = _node.get("observers");
        if (_observersNode == null) {
            _object.observers = new ArrayList<Integer>(0);
        } else {
            if (!_observersNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection5 = new ArrayList<Integer>(_observersNode.size());
            _object.observers = _collection5;
            for (Object _element : _observersNode) {
                _collection5.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _deprecatedDoNotUseTag1003Node = _node.get("deprecatedDoNotUseTag1003");
        if (_deprecatedDoNotUseTag1003Node == null) {
            _object.deprecatedDoNotUseTag1003 = new ArrayList<Integer>(0);
        } else {
            if (!_deprecatedDoNotUseTag1003Node.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection6 = new ArrayList<Integer>(_deprecatedDoNotUseTag1003Node.size());
            _object.deprecatedDoNotUseTag1003 = _collection6;
            for (Object _element : _deprecatedDoNotUseTag1003Node) {
                _collection6.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _deprecatedDoNotUseTag1004Node = _node.get("deprecatedDoNotUseTag1004");
        if (_deprecatedDoNotUseTag1004Node == null) {
            _object.deprecatedDoNotUseTag1004 = new ArrayList<Integer>(0);
        } else {
            if (!_deprecatedDoNotUseTag1004Node.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection7 = new ArrayList<Integer>(_deprecatedDoNotUseTag1004Node.size());
            _object.deprecatedDoNotUseTag1004 = _collection7;
            for (Object _element : _deprecatedDoNotUseTag1004Node) {
                _collection7.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _removingObserversNode = _node.get("removingObservers");
        if (_removingObserversNode == null) {
            _object.removingObservers = new ArrayList<Integer>(0);
        } else {
            if (!_removingObserversNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection8 = new ArrayList<Integer>(_removingObserversNode.size());
            _object.removingObservers = _collection8;
            for (Object _element : _removingObserversNode) {
                _collection8.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _addingObserversNode = _node.get("addingObservers");
        if (_addingObserversNode == null) {
            _object.addingObservers = new ArrayList<Integer>(0);
        } else {
            if (!_addingObserversNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection9 = new ArrayList<Integer>(_addingObserversNode.size());
            _object.addingObservers = _collection9;
            for (Object _element : _addingObserversNode) {
                _collection9.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _directoriesNode = _node.get("directories");
        if (_directoriesNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("PartitionRecord: unable to locate field 'directories', which is mandatory in version " + _version);
            }
            _object.directories = new ArrayList<Uuid>(0);
        } else {
            if (!_directoriesNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Uuid> _collection10 = new ArrayList<Uuid>(_directoriesNode.size());
            _object.directories = _collection10;
            for (Object _element : _directoriesNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("PartitionRecord element expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection10.add(Uuid.fromString((String)_element.asText()));
            }
        }
        JsonNode _eligibleLeaderReplicasNode = _node.get("eligibleLeaderReplicas");
        if (_eligibleLeaderReplicasNode == null) {
            _object.eligibleLeaderReplicas = null;
        } else if (_eligibleLeaderReplicasNode.isNull()) {
            _object.eligibleLeaderReplicas = null;
        } else {
            if (!_eligibleLeaderReplicasNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection11 = new ArrayList<Integer>(_eligibleLeaderReplicasNode.size());
            _object.eligibleLeaderReplicas = _collection11;
            for (JsonNode _element : _eligibleLeaderReplicasNode) {
                _collection11.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _lastKnownElrNode = _node.get("lastKnownElr");
        if (_lastKnownElrNode == null) {
            _object.lastKnownElr = null;
        } else if (_lastKnownElrNode.isNull()) {
            _object.lastKnownElr = null;
        } else {
            if (!_lastKnownElrNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection12 = new ArrayList<Integer>(_lastKnownElrNode.size());
            _object.lastKnownElr = _collection12;
            for (JsonNode _element : _lastKnownElrNode) {
                _collection12.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(PartitionRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("partitionId", (JsonNode)new IntNode(_object.partitionId));
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        ArrayNode _replicasArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.replicas) {
            _replicasArray.add((JsonNode)new IntNode(n.intValue()));
        }
        _node.set("replicas", (JsonNode)_replicasArray);
        ArrayNode _isrArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.isr) {
            _isrArray.add((JsonNode)new IntNode(n.intValue()));
        }
        _node.set("isr", (JsonNode)_isrArray);
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.removingReplicas) {
            arrayNode.add((JsonNode)new IntNode(n.intValue()));
        }
        _node.set("removingReplicas", (JsonNode)arrayNode);
        ArrayNode arrayNode2 = new ArrayNode(JsonNodeFactory.instance);
        for (Integer _element : _object.addingReplicas) {
            arrayNode2.add((JsonNode)new IntNode(_element.intValue()));
        }
        _node.set("addingReplicas", (JsonNode)arrayNode2);
        _node.set("leader", (JsonNode)new IntNode(_object.leader));
        if (_object.leaderRecoveryState != 0) {
            _node.set("leaderRecoveryState", (JsonNode)new ShortNode((short)_object.leaderRecoveryState));
        }
        _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
        _node.set("partitionEpoch", (JsonNode)new IntNode(_object.partitionEpoch));
        if (_object.linkedLeaderEpoch != -1) {
            _node.set("linkedLeaderEpoch", (JsonNode)new IntNode(_object.linkedLeaderEpoch));
        }
        if (_object.linkState != -1) {
            _node.set("linkState", (JsonNode)new ShortNode((short)_object.linkState));
        }
        if (!_object.observers.isEmpty()) {
            ArrayNode arrayNode3 = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.observers) {
                arrayNode3.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("observers", (JsonNode)arrayNode3);
        }
        if (!_object.deprecatedDoNotUseTag1003.isEmpty()) {
            ArrayNode arrayNode4 = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.deprecatedDoNotUseTag1003) {
                arrayNode4.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("deprecatedDoNotUseTag1003", (JsonNode)arrayNode4);
        }
        if (!_object.deprecatedDoNotUseTag1004.isEmpty()) {
            ArrayNode arrayNode5 = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.deprecatedDoNotUseTag1004) {
                arrayNode5.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("deprecatedDoNotUseTag1004", (JsonNode)arrayNode5);
        }
        if (!_object.removingObservers.isEmpty()) {
            ArrayNode arrayNode6 = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.removingObservers) {
                arrayNode6.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("removingObservers", (JsonNode)arrayNode6);
        }
        if (!_object.addingObservers.isEmpty()) {
            ArrayNode arrayNode7 = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.addingObservers) {
                arrayNode7.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("addingObservers", (JsonNode)arrayNode7);
        }
        if (_version >= 1) {
            ArrayNode arrayNode8 = new ArrayNode(JsonNodeFactory.instance);
            for (Uuid uuid : _object.directories) {
                arrayNode8.add((JsonNode)new TextNode(uuid.toString()));
            }
            _node.set("directories", (JsonNode)arrayNode8);
        } else if (!_object.directories.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default directories at version " + _version);
        }
        if (_version >= 2) {
            if (_object.eligibleLeaderReplicas != null) {
                ArrayNode arrayNode9 = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.eligibleLeaderReplicas) {
                    arrayNode9.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("eligibleLeaderReplicas", (JsonNode)arrayNode9);
            }
        } else if (_object.eligibleLeaderReplicas != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default eligibleLeaderReplicas at version " + _version);
        }
        if (_version >= 2) {
            if (_object.lastKnownElr != null) {
                ArrayNode arrayNode10 = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.lastKnownElr) {
                    arrayNode10.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("lastKnownElr", (JsonNode)arrayNode10);
            }
        } else if (_object.lastKnownElr != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default lastKnownElr at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(PartitionRecord _object, short _version) {
        return PartitionRecordJsonConverter.write(_object, _version, true);
    }
}

