/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class QuorumControllerMetrics
implements AutoCloseable {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName GLOBAL_TOPIC_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName GLOBAL_OFFLINE_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName GLOBAL_UNDER_MIN_ISR_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalUnderMinIsrPartitionCount");
    private static final MetricName GLOBAL_PARTITION_AVAILABILITY = QuorumControllerMetrics.getMetricName("KafkaController", "PartitionAvailability");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private static final MetricName LAST_APPLIED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordOffset");
    private static final MetricName LAST_COMMITTED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastCommittedRecordOffset");
    private static final MetricName LAST_APPLIED_RECORD_TIMESTAMP = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordTimestamp");
    private static final MetricName LAST_APPLIED_RECORD_LAG_MS = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordLagMs");
    private static final MetricName TIMED_OUT_BROKER_HEARTBEAT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "TimedOutBrokerHeartbeatCount");
    private static final MetricName EVENT_QUEUE_OPERATIONS_STARTED_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "EventQueueOperationsStartedCount");
    private static final MetricName EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "EventQueueOperationsTimedOutCount");
    private static final MetricName NEW_ACTIVE_CONTROLLERS_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "NewActiveControllersCount");
    private static final MetricName ENCRYPTOR_SECRET_AGE_DAYS = QuorumControllerMetrics.getMetricName("KafkaController", "EncryptorSecretAgeDays");
    private static final String TIME_SINCE_LAST_HEARTBEAT_RECEIVED_METRIC_NAME = "TimeSinceLastHeartbeatReceivedMs";
    private static final String BROKER_ID_TAG = "broker";
    private final Optional<MetricsRegistry> registry;
    private final Time time;
    private volatile boolean active;
    private volatile int globalTopicCount;
    private final Map<String, TenantPartitionMetrics> tenantPartitionMetricsMap = new ConcurrentHashMap<String, TenantPartitionMetrics>();
    private volatile int globalPartitionCount;
    private volatile int globalOfflinePartitionCount;
    private volatile int globalUnderMinIsrCount;
    private volatile double globalPartitionAvailability;
    private volatile int preferredReplicaImbalanceCount;
    private final AtomicLong lastAppliedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastCommittedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastAppliedRecordTimestamp = new AtomicLong(0L);
    private final Consumer<Long> eventQueueTimeUpdater;
    private final Consumer<Long> eventQueueProcessingTimeUpdater;
    private final AtomicLong timedOutHeartbeats = new AtomicLong(0L);
    private final AtomicLong operationsStarted = new AtomicLong(0L);
    private final AtomicLong operationsTimedOut = new AtomicLong(0L);
    private final AtomicLong newActiveControllers = new AtomicLong(0L);
    private final AtomicReference<EncryptorAndAge> encryptorAndAge = new AtomicReference<EncryptorAndAge>(new EncryptorAndAge());
    private final Map<Integer, Long> brokerContactTimesMs = new ConcurrentHashMap<Integer, Long>();
    private final int sessionTimeoutMs;
    private final Metrics kafkaMetrics;
    private final Sensor controllerLoadSensor;

    private Consumer<Long> newHistogram(MetricName name, boolean biased) {
        if (this.registry.isPresent()) {
            Histogram histogram = this.registry.get().newHistogram(name, biased);
            return arg_0 -> ((Histogram)histogram).update(arg_0);
        }
        return __ -> {};
    }

    public QuorumControllerMetrics(Optional<MetricsRegistry> registry, final Time time, Metrics kafkaMetrics, int sessionTimeoutMs) {
        this.registry = registry;
        this.time = time;
        this.active = false;
        this.globalTopicCount = 0;
        this.globalPartitionCount = 0;
        this.globalOfflinePartitionCount = 0;
        this.globalUnderMinIsrCount = 0;
        this.preferredReplicaImbalanceCount = 0;
        registry.ifPresent(r -> r.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        }));
        this.eventQueueTimeUpdater = this.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTimeUpdater = this.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        this.kafkaMetrics = kafkaMetrics;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.controllerLoadSensor = kafkaMetrics.sensor("ControllerLoadTime");
        this.controllerLoadSensor.add(kafkaMetrics.metricName("controller-load-time-max", "controller-metrics", "The max time it took to load the controller"), (MeasurableStat)new Max());
        this.controllerLoadSensor.add(kafkaMetrics.metricName("controller-load-time-avg", "controller-metrics", "The average time it took to load the controller"), (MeasurableStat)new Avg());
        registry.ifPresent(r -> r.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalTopicCount;
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalPartitionCount;
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalOfflinePartitionCount;
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_UNDER_MIN_ISR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalUnderMinIsrCount;
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_AVAILABILITY, (Gauge)new Gauge<Double>(){

            public Double value() {
                return QuorumControllerMetrics.this.globalPartitionAvailability;
            }
        }));
        registry.ifPresent(r -> r.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.preferredReplicaImbalanceCount;
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_COMMITTED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastCommittedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_TIMESTAMP, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_LAG_MS, (Gauge)new Gauge<Long>(this){
            final /* synthetic */ QuorumControllerMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Long value() {
                return time.milliseconds() - this.this$0.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(TIMED_OUT_BROKER_HEARTBEAT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.timedOutHeartbeats();
            }
        }));
        registry.ifPresent(r -> r.newGauge(EVENT_QUEUE_OPERATIONS_STARTED_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.operationsStarted();
            }
        }));
        registry.ifPresent(r -> r.newGauge(EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.operationsTimedOut();
            }
        }));
        registry.ifPresent(r -> r.newGauge(NEW_ACTIVE_CONTROLLERS_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.newActiveControllers();
            }
        }));
        registry.ifPresent(r -> r.newGauge(ENCRYPTOR_SECRET_AGE_DAYS, (Gauge)new Gauge<Double>(this){
            final /* synthetic */ QuorumControllerMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Double value() {
                return this.this$0.currentEncryptorAndAge().encryptorAgeInDays(time);
            }
        }));
    }

    public void recordControllerLoadTime(long startMs, long endMs) {
        this.controllerLoadSensor.record((double)(endMs - startMs), endMs, false);
    }

    public void addTimeSinceLastHeartbeatMetric(final int brokerId) {
        this.brokerContactTimesMs.put(brokerId, this.time.milliseconds());
        this.registry.ifPresent(r -> r.newGauge(QuorumControllerMetrics.getBrokerIdTagMetricName("KafkaController", TIME_SINCE_LAST_HEARTBEAT_RECEIVED_METRIC_NAME, brokerId), (Gauge)new Gauge<Integer>(this){
            final /* synthetic */ QuorumControllerMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Integer value() {
                return this.this$0.timeSinceLastHeartbeatMs(brokerId);
            }
        }));
    }

    public void removeTimeSinceLastHeartbeatMetric(int brokerId) {
        this.registry.ifPresent(r -> r.removeMetric(QuorumControllerMetrics.getBrokerIdTagMetricName("KafkaController", TIME_SINCE_LAST_HEARTBEAT_RECEIVED_METRIC_NAME, brokerId)));
        this.brokerContactTimesMs.remove(brokerId);
    }

    public void removeTimeSinceLastHeartbeatMetrics() {
        for (int brokerId : this.brokerContactTimesMs.keySet()) {
            this.removeTimeSinceLastHeartbeatMetric(brokerId);
        }
        this.brokerContactTimesMs.clear();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean active() {
        return this.active;
    }

    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTimeUpdater.accept(durationMs);
    }

    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTimeUpdater.accept(durationMs);
    }

    public void setGlobalTopicCount(int topicCount) {
        this.globalTopicCount = topicCount;
    }

    public int globalTopicCount() {
        return this.globalTopicCount;
    }

    public void setGlobalPartitionCount(int partitionCount) {
        this.globalPartitionCount = partitionCount;
        this.updateGlobalPartitionAvailabilitySLO();
    }

    public int globalPartitionCount() {
        return this.globalPartitionCount;
    }

    public void setGlobalOfflinePartitionCount(int offlinePartitions) {
        this.globalOfflinePartitionCount = offlinePartitions;
        this.updateGlobalPartitionAvailabilitySLO();
    }

    public int globalOfflinePartitionCount() {
        return this.globalOfflinePartitionCount;
    }

    public double globalPartitionAvailability() {
        return this.globalPartitionAvailability;
    }

    public void setGlobalUnderMinIsrCount(int count) {
        this.globalUnderMinIsrCount = count;
        this.updateGlobalPartitionAvailabilitySLO();
    }

    public int globalUnderMinIsrCount() {
        return this.globalUnderMinIsrCount;
    }

    public void setTenantPartitionCount(String tenant, int count) {
        TenantPartitionMetrics metrics = this.getOrCreateTenantMetrics(tenant);
        if (metrics != null) {
            metrics.setPartitionCount(count);
        }
    }

    public void setTenantOfflinePartitionCount(String tenant, int count) {
        TenantPartitionMetrics metrics = this.getOrCreateTenantMetrics(tenant);
        if (metrics != null) {
            metrics.setOfflinePartitionCount(count);
        }
    }

    public void setTenantUnderMinIsrCount(String tenant, int count) {
        TenantPartitionMetrics metrics = this.getOrCreateTenantMetrics(tenant);
        if (metrics != null) {
            metrics.setUnderMinIsrCount(count);
        }
    }

    public void removeTenant(String tenant) {
        this.removeTenantMetric(tenant);
        this.tenantPartitionMetricsMap.remove(tenant);
    }

    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalanceCount = replicaImbalances;
    }

    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount;
    }

    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset.set(offset);
    }

    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset.get();
    }

    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset.set(offset);
    }

    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset.get();
    }

    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp.set(timestamp);
    }

    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp.get();
    }

    public void incrementTimedOutHeartbeats() {
        this.timedOutHeartbeats.incrementAndGet();
    }

    public long timedOutHeartbeats() {
        return this.timedOutHeartbeats.get();
    }

    public void incrementOperationsStarted() {
        this.operationsStarted.incrementAndGet();
    }

    public long operationsStarted() {
        return this.operationsStarted.get();
    }

    public void incrementOperationsTimedOut() {
        this.operationsTimedOut.incrementAndGet();
    }

    public long operationsTimedOut() {
        return this.operationsTimedOut.get();
    }

    public void incrementNewActiveControllers() {
        this.newActiveControllers.incrementAndGet();
    }

    public long newActiveControllers() {
        return this.newActiveControllers.get();
    }

    public void installNewEncryptor(Uuid encryptorId, long createTimeMillisSinceEpoch) {
        this.encryptorAndAge.set(new EncryptorAndAge(encryptorId, createTimeMillisSinceEpoch));
    }

    public EncryptorAndAge currentEncryptorAndAge() {
        return this.encryptorAndAge.get();
    }

    public void updateBrokerContactTime(int brokerId) {
        this.brokerContactTimesMs.put(brokerId, this.time.milliseconds());
    }

    public int timeSinceLastHeartbeatMs(int brokerId) {
        Long lastTime = this.brokerContactTimesMs.get(brokerId);
        if (lastTime == null) {
            return this.sessionTimeoutMs;
        }
        return Math.min((int)(this.time.milliseconds() - lastTime), this.sessionTimeoutMs);
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> List.of(ACTIVE_CONTROLLER_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, GLOBAL_OFFLINE_PARTITION_COUNT, GLOBAL_UNDER_MIN_ISR_COUNT, GLOBAL_PARTITION_AVAILABILITY, PREFERRED_REPLICA_IMBALANCE_COUNT, LAST_APPLIED_RECORD_OFFSET, LAST_COMMITTED_RECORD_OFFSET, LAST_APPLIED_RECORD_TIMESTAMP, LAST_APPLIED_RECORD_LAG_MS, TIMED_OUT_BROKER_HEARTBEAT_COUNT, EVENT_QUEUE_OPERATIONS_STARTED_COUNT, EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT, NEW_ACTIVE_CONTROLLERS_COUNT, ENCRYPTOR_SECRET_AGE_DAYS).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        this.tenantPartitionMetricsMap.keySet().forEach(this::removeTenantMetric);
        this.tenantPartitionMetricsMap.clear();
        List.of(this.controllerLoadSensor).stream().map(Sensor::name).forEach(arg_0 -> ((Metrics)this.kafkaMetrics).removeSensor(arg_0));
        this.removeTimeSinceLastHeartbeatMetrics();
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    private static MetricName getTenantMetricName(String tenant) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("tenant", tenant);
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"TenantPartitionAvailability", tags);
    }

    private static double computePartitionAvailabilitySLO(double partitionCount, double offlineCount, double underMinIsrCount) {
        return partitionCount == 0.0 ? 1.0 : (partitionCount - underMinIsrCount - offlineCount) / partitionCount;
    }

    private void updateGlobalPartitionAvailabilitySLO() {
        this.globalPartitionAvailability = QuorumControllerMetrics.computePartitionAvailabilitySLO(this.globalPartitionCount, this.globalOfflinePartitionCount, this.globalUnderMinIsrCount);
    }

    Map<String, TenantPartitionMetrics> getTenantPartitionMetricsMap() {
        return this.tenantPartitionMetricsMap;
    }

    Double getTenantPartitionAvailabilitySLO(String tenant) {
        return this.getOrCreateTenantMetrics(tenant).getPartitionAvailability();
    }

    private TenantPartitionMetrics getOrCreateTenantMetrics(String tenant) {
        if (tenant == null) {
            return null;
        }
        return this.tenantPartitionMetricsMap.computeIfAbsent(tenant, x$0 -> new TenantPartitionMetrics((String)x$0));
    }

    private void removeTenantMetric(String tenant) {
        this.registry.ifPresent(r -> r.removeMetric(QuorumControllerMetrics.getTenantMetricName(tenant)));
    }

    Map<String, TenantPartitionMetrics> tenantMetrics() {
        return this.tenantPartitionMetricsMap;
    }

    private static MetricName getBrokerIdTagMetricName(String type, String name, int brokerId) {
        LinkedHashMap<String, String> brokerIdTag = new LinkedHashMap<String, String>();
        brokerIdTag.put(BROKER_ID_TAG, Integer.toString(brokerId));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name, brokerIdTag);
    }

    public static final class EncryptorAndAge {
        private static final long MILLIS_PER_DAY = 86400000L;
        private final Uuid encryptorId;
        private final long createTimeMillisSinceEpoch;

        public EncryptorAndAge() {
            this.encryptorId = Uuid.ZERO_UUID;
            this.createTimeMillisSinceEpoch = -62125920000000L;
        }

        public EncryptorAndAge(Uuid encryptorId, long createTimeMillisSinceEpoch) {
            this.encryptorId = Objects.requireNonNull(encryptorId);
            this.createTimeMillisSinceEpoch = createTimeMillisSinceEpoch;
        }

        public Uuid encryptorId() {
            return this.encryptorId;
        }

        public double encryptorAgeInDays(Time time) {
            return (double)(time.milliseconds() - this.createTimeMillisSinceEpoch) * 1.0 / 8.64E7;
        }
    }

    class TenantPartitionMetrics {
        private volatile double partitionAvailability = 0.0;
        private volatile int underMinIsrCount = 0;
        private volatile int partitionCount = 0;
        private volatile int offlinePartitionCount = 0;

        public double getPartitionAvailability() {
            return this.partitionAvailability;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public int getOfflinePartitionCount() {
            return this.offlinePartitionCount;
        }

        public int getUnderMinIsrPartitionsCount() {
            return this.underMinIsrCount;
        }

        private TenantPartitionMetrics(String tenant) {
            this.createGauge(QuorumControllerMetrics.getTenantMetricName(tenant), this);
        }

        private void setPartitionCount(int count) {
            this.partitionCount = count;
            this.updatePartitionAvailabilitySLO();
        }

        private void setOfflinePartitionCount(int count) {
            this.offlinePartitionCount = count;
            this.updatePartitionAvailabilitySLO();
        }

        private void setUnderMinIsrCount(int count) {
            this.underMinIsrCount = count;
            this.updatePartitionAvailabilitySLO();
        }

        private void updatePartitionAvailabilitySLO() {
            this.partitionAvailability = QuorumControllerMetrics.computePartitionAvailabilitySLO(this.partitionCount, this.offlinePartitionCount, this.underMinIsrCount);
        }

        private void createGauge(MetricName metric, final TenantPartitionMetrics obj) {
            QuorumControllerMetrics.this.registry.ifPresent(r -> r.newGauge(metric, (Gauge)new Gauge<Double>(this){
                final /* synthetic */ TenantPartitionMetrics this$1;
                {
                    this.this$1 = this$1;
                }

                public Double value() {
                    return obj.getPartitionAvailability();
                }
            }));
        }
    }
}

