/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.ClusterLink;

public class ClusterLinksImageByIdNode
implements MetadataNode {
    public static final String NAME = "byId";
    private final ClusterLinksImage image;

    public ClusterLinksImageByIdNode(ClusterLinksImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (Uuid id : this.image.linksById().keySet()) {
            childNames.add(id.toString());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        Uuid id;
        try {
            id = Uuid.fromString((String)name);
        }
        catch (Exception e) {
            return null;
        }
        ClusterLink link = this.image.linksById().get(id);
        if (link == null) {
            return null;
        }
        return new MetadataLeafNode(link.toString());
    }
}

