/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.image.ConfluentKeyValueStreamsImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.InternalTopicType;

public class ConfluentKeyValueStreamsImageNode
implements MetadataNode {
    public static final String NAME = "byId";
    private final ConfluentKeyValueStreamsImage image;

    public ConfluentKeyValueStreamsImageNode(ConfluentKeyValueStreamsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (short topicType : this.image.topicTypeKv().keySet()) {
            childNames.add(InternalTopicType.from(topicType).topicName());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        InternalTopicType t = InternalTopicType.fromTopicName(name);
        Map<String, String> topicKeyValueStreamsChanges = this.image.topicTypeKv().get(t.value());
        Map<Short, Long> topicOffsetChanges = this.image.topicTypeOffset().get(t.value());
        String topicChangeString = "KeyValueStreamsChanges=" + topicKeyValueStreamsChanges.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ")) + ", TopicOffsetChanges=" + topicOffsetChanges.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + ")";
        return new MetadataLeafNode(topicChangeString);
    }
}

