/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public enum InternalTopicType {
    UNKNOWN(-1, "UNKNOWN", 0),
    RBAC_AUTH(0, "_confluent-metadata-auth", 6),
    USER_METADATA(1, "_confluent-user_metadata", 6);

    private final short value;
    private final String topicName;
    private final int numberOfPartitions;
    public static final List<InternalTopicType> VALID_VALUES;

    private InternalTopicType(short value, String topicName, int numberOfPartitions) {
        this.value = value;
        this.topicName = topicName;
        this.numberOfPartitions = numberOfPartitions;
    }

    public short value() {
        return this.value;
    }

    public String topicName() {
        return this.topicName;
    }

    public int numberOfPartitions() {
        return this.numberOfPartitions;
    }

    public static InternalTopicType from(short value) {
        for (InternalTopicType t : InternalTopicType.values()) {
            if (t.value() != value) continue;
            return t;
        }
        return UNKNOWN;
    }

    public static InternalTopicType fromTopicName(String name) {
        for (InternalTopicType t : InternalTopicType.values()) {
            if (!t.topicName().equalsIgnoreCase(name)) continue;
            return t;
        }
        return UNKNOWN;
    }

    static {
        VALID_VALUES = Collections.unmodifiableList(Arrays.stream(InternalTopicType.values()).filter(s -> s != UNKNOWN).collect(Collectors.toList()));
    }
}

