/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.ingester;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.InternalTopicType;
import org.apache.kafka.metadata.ingester.IngestionWorker;

public class IngestionWorkerMetrics {
    public static final String INGESTER_CONSUMER_LAG_GROUP_NAME = "kv-stream-consumer-ingester-lag";
    public static final String INGESTER_CONSUMER_LAG_MAX = "kv-stream-consumer-ingester-lag-max";
    private final InternalTopicType type;
    private final IngestionWorker worker;
    private final Metrics metrics;
    private List<MetricName> metricNameList;

    public IngestionWorkerMetrics(Metrics metrics, InternalTopicType type, IngestionWorker worker) {
        this.metrics = metrics;
        this.worker = worker;
        this.type = type;
        this.metricNameList = new ArrayList<MetricName>();
        this.registerLagGauge();
    }

    final void registerLagGauge() {
        MetricName metricNameLagMax = this.metrics.metricName(INGESTER_CONSUMER_LAG_MAX, INGESTER_CONSUMER_LAG_GROUP_NAME, "max consumer lag number for partition", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic_name", (Object)this.type.topicName())}));
        this.metricNameList.add(metricNameLagMax);
        this.metrics.addMetricIfAbsent(metricNameLagMax, null, (MetricValueProvider)((Gauge)(config, now) -> this.getConsumerLagMax()));
    }

    private long getConsumerLagMax() {
        Map<MetricName, ? extends Metric> metrics = this.worker.getConsumerMetrics();
        for (MetricName m : metrics.keySet()) {
            if (!m.name().contains("records-lag-max")) continue;
            return (Long)metrics.get(m).metricValue();
        }
        return -1L;
    }

    public void close() {
        for (MetricName n : this.metricNameList) {
            this.metrics.removeMetric(n);
        }
    }
}

