/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.ingester;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.metadata.ingester.Ingester;
import org.apache.kafka.metadata.ingester.IngesterRecord;
import org.apache.kafka.metadata.ingester.IngestionWorker;
import org.apache.kafka.metadata.ingester.IngestionWorkerFactory;
import org.apache.kafka.metadata.ingester.IngestionWorkerManager;
import org.slf4j.Logger;

public final class KafkaConsumerIngestionWorker
implements IngestionWorker,
Runnable {
    private final Logger log;
    private final long maxPollMs;
    private final IngestionWorkerManager manager;
    private final Map<TopicPartition, Optional<Long>> initialOffsets;
    private IngestionWorkerState state;
    private final Consumer<String, String> consumer;
    private final Thread thread;

    static String effectiveLogContextPrefix(String input, long epoch) {
        int lastBracketIndex = input.lastIndexOf(93);
        if (lastBracketIndex < 0) {
            return input;
        }
        return input.substring(0, lastBracketIndex) + ", epoch=" + epoch + "] ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaConsumerIngestionWorker(Factory factory, IngestionWorkerManager manager, Map<TopicPartition, Optional<Long>> initialOffsets) {
        this.log = new LogContext(KafkaConsumerIngestionWorker.effectiveLogContextPrefix(manager.logContext().logPrefix(), manager.epoch())).logger(KafkaConsumerIngestionWorker.class);
        this.maxPollMs = factory.maxPollMs;
        this.manager = manager;
        KafkaConsumerIngestionWorker kafkaConsumerIngestionWorker = this;
        synchronized (kafkaConsumerIngestionWorker) {
            this.initialOffsets = new HashMap<TopicPartition, Optional<Long>>(initialOffsets);
            this.state = IngestionWorkerState.UNINITIALIZED;
            this.consumer = factory.consumerFactory.apply(factory.configs);
            this.log.info("creating consumer");
            try {
                this.thread = ThreadUtils.createThreadFactory((String)(factory.name + "-kafka-consumer-ingestion-worker-" + manager.epoch()), (boolean)true).newThread(this);
                this.thread.start();
            }
            catch (Exception e) {
                this.consumer.close();
                throw e;
            }
        }
        this.log.info("CREATED KafkaConsumerIngestionWorker with factory = " + String.valueOf(factory));
    }

    @Override
    public Map<MetricName, ? extends Metric> getConsumerMetrics() {
        return this.consumer.metrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginShutdown() {
        KafkaConsumerIngestionWorker kafkaConsumerIngestionWorker = this;
        synchronized (kafkaConsumerIngestionWorker) {
            this.log.info("BEGINSHUTDOWN. state = " + String.valueOf((Object)this.state));
            if (this.state == IngestionWorkerState.SHUTTING_DOWN) {
                return;
            }
            this.state = IngestionWorkerState.SHUTTING_DOWN;
        }
        this.consumer.wakeup();
    }

    @Override
    public void run() {
        this.log.info("starting thread.");
        Throwable exitException = null;
        try {
            while (this.execute()) {
            }
        }
        catch (Throwable e) {
            this.log.error("thread exiting with error", e);
            exitException = e;
        }
        try {
            this.consumer.close(CloseOptions.timeout((Duration)Duration.ofMinutes(1L)));
        }
        catch (Throwable e) {
            this.log.error("Error closing consumer", e);
        }
        this.manager.handleWorkerShutdownComplete(exitException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute() throws Throwable {
        IngestionWorkerState curState;
        KafkaConsumerIngestionWorker kafkaConsumerIngestionWorker = this;
        synchronized (kafkaConsumerIngestionWorker) {
            curState = this.state;
        }
        switch (curState.ordinal()) {
            case 0: {
                this.initialize();
                return true;
            }
            case 1: {
                this.reinitialize();
                return true;
            }
            case 2: 
            case 3: {
                this.poll();
                return true;
            }
            case 4: {
                this.log.debug("entered SHUTTING_DOWN state.");
                return false;
            }
        }
        return true;
    }

    void initialize() {
        this.log.info("initializing offsets: {}.", (Object)Ingester.offsetsToString(this.initialOffsets));
        this.consumer.assign(this.initialOffsets.keySet());
        HashSet<TopicPartition> unInitializedPartitions = new HashSet<TopicPartition>();
        for (Map.Entry<TopicPartition, Optional<Long>> entry : this.initialOffsets.entrySet()) {
            if (entry.getValue().isPresent()) {
                this.consumer.seek(entry.getKey(), entry.getValue().get().longValue());
                continue;
            }
            unInitializedPartitions.add(entry.getKey());
        }
        this.consumer.seekToBeginning(unInitializedPartitions);
        if (this.maybeTransition(IngestionWorkerState.RUNNING)) {
            this.log.info("entering RUNNING state.");
        }
    }

    synchronized boolean maybeTransition(IngestionWorkerState newState) {
        if (this.state == IngestionWorkerState.SHUTTING_DOWN) {
            return false;
        }
        if (this.state == newState) {
            return false;
        }
        this.state = newState;
        return true;
    }

    void reinitialize() {
        this.log.error("resetting offsets to the beginning for: {}", Ingester.findUniqueTopicNames(this.initialOffsets.keySet()));
        this.consumer.seekToBeginning(this.initialOffsets.keySet());
        if (this.maybeTransition(IngestionWorkerState.RUNNING)) {
            this.log.info("re-entering RUNNING state.");
        }
    }

    void poll() throws Throwable {
        List<IngesterRecord> ingesterRecords;
        ConsumerRecords records;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("polling for {} ms", (Object)this.maxPollMs);
            }
            records = this.consumer.poll(Duration.ofMillis(this.maxPollMs));
            if (this.log.isTraceEnabled()) {
                this.log.trace("got {} records", (Object)records.count());
            }
        }
        catch (WakeupException e) {
            this.log.debug("Received wakeup exception");
            return;
        }
        catch (InterruptException e) {
            this.log.warn("interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
        catch (InvalidOffsetException e) {
            this.log.error("Offset out of range error", (Throwable)e);
            this.maybeTransition(IngestionWorkerState.OFFSET_OUT_OF_RANGE);
            return;
        }
        if (records.isEmpty()) {
            ingesterRecords = List.of();
        } else {
            ingesterRecords = new ArrayList(records.count());
            records.forEach(record -> ingesterRecords.add(IngesterRecord.fromConsumerRecord((ConsumerRecord<String, String>)record)));
        }
        if (this.manager.handleRecords(ingesterRecords)) {
            if (this.maybeTransition(IngestionWorkerState.RUNNING)) {
                this.log.debug("re-entering RUNNING state.");
                this.consumer.resume(this.initialOffsets.keySet());
            }
        } else if (this.maybeTransition(IngestionWorkerState.THROTTLED)) {
            this.log.debug("throttling for {} ms.", (Object)this.maxPollMs);
            this.consumer.pause(this.initialOffsets.keySet());
        }
    }

    public static class Factory
    implements IngestionWorkerFactory {
        private final String name;
        private final Map<String, Object> configs;
        private long maxPollMs = 20000L;
        private Function<Map<String, Object>, Consumer<String, String>> consumerFactory = consumerConfigs -> new KafkaConsumer(consumerConfigs, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());

        Factory setConsumerFactory(Function<Map<String, Object>, Consumer<String, String>> consumerFactory) {
            this.consumerFactory = consumerFactory;
            return this;
        }

        public Factory(String name, Map<String, Object> configs) {
            this.name = name;
            this.configs = new HashMap<String, Object>(configs);
            this.configs.put("enable.auto.commit", "false");
        }

        @Override
        public IngestionWorker create(IngestionWorkerManager manager, Map<TopicPartition, Optional<Long>> initialOffsets) {
            return new KafkaConsumerIngestionWorker(this, manager, initialOffsets);
        }
    }

    static enum IngestionWorkerState {
        UNINITIALIZED,
        OFFSET_OUT_OF_RANGE,
        RUNNING,
        THROTTLED,
        SHUTTING_DOWN;

    }
}

