/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class DropType
extends Statement
implements ExecutableDdlStatement {
    private final String typeName;
    private final boolean ifExists;

    public DropType(Optional<NodeLocation> location, String typeName, boolean ifExists) {
        super(location);
        this.typeName = Objects.requireNonNull(typeName, "typeName");
        this.ifExists = ifExists;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropType(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropType that = (DropType)o;
        return Objects.equals(this.typeName, that.typeName) && this.ifExists == that.ifExists;
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.ifExists);
    }

    public String toString() {
        return "DropType{typeName='" + this.typeName + "',ifExists=" + this.ifExists + "}";
    }
}

